package net.ifok.common.constants;
/**
 * @Description:  常用正则表达式常量
 * @Author: xq 
 * @Date: 2021/5/27 17:01
 **/
public class RegExpConstant {
	/**
	 * 手机电话号码
	 */
	public final static String MOBILE="^(((13[0-9])|(15[^4])|(18[0-9])|(17[0-9])|(19[8-9])|(14[5-8])|(166))\\d{8}$)?$";
	/**
	 * 手机号码或空
	 */
	public final static String MOBILE_OR_EMPTY="^$|"+MOBILE;
	/**
	 * 电子邮箱
	 */
	public final static String EMAIL="^([a-zA-Z]|[0-9])(\\w|\\-|\\.)+@[a-zA-Z0-9]+\\.([a-zA-Z]{2,6})$";
	/**
	 * 电子邮件或空
	 */
	public final static String EMAIL_OR_EMPTY="^$|"+EMAIL;
	/**
	 * 座机号码
	 */
	public final static String TEL="^(0[0-9]{2,3}\\-)?([1-9][0-9]{6,7})?$";
	/**
	 * 座机号码或者空
	 */
	public final static String TEL_OR_EMPTY="^|"+TEL;
	/**
	 * 时间格式 12:12:59
 	 */
	public final static String TIME="^(\\d{2}\\s*:\\s*\\d{2}\\s*:\\s*\\d{2}$)?$";
	/**
	 * 时间格式或者空
	 */
	public final static String TIME_OR_EMPTY="^$|"+TIME;
	/**
	 * 日期时间 2020-01-01 12:20:40
	 */
	public final static String  DATE_TIME="^([1-9]\\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])\\s+(20|21|22|23|[0-1]\\d):[0-5]\\d:[0-5]\\d$)?$";
	/**
	 * 日期时间或空
	 */
	public final static String DATE_TIME_OR_EMPTY="^$|"+DATE_TIME;
	/**
	 * 日期格式
	 */
	public final static String  DATE="^([1-9]\\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1]))?$";
	/**
	 * 日期或者空
	 */
	public final static String DATE_OR_EMPTY="^$|"+DATE;
	/**
	 * 两位小数
	 */
	public final static String FLOAT_2="^\\d+(\\.\\d{1,2})?$";
	/**
	 * 正小数
	 */
	public final static String POSITIVE_FLOAT="^\\d+\\.\\d+|\\d+$|\\d?$";
	/**
	 * 正整数
	 */
	public final static String POSITIVE_INTEGER="^([0-9]*[1-9][0-9]*$)?$";
	/**
	 * 整数
	 */
	public final static String INTEGER="^(-?\\d+$)?$";
	
	/**
	 * Emoji表情
	 */
	public final static String EMOJI="[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]";
	
	/**
	 * url地址
	 */
	public final static String WEB_URL="^(((http|https)://)(([a-zA-Z0-9\\._-]+\\.[a-zA-Z]{2,6})|([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}))(:[0-9]{1,4})*(/[a-zA-Z0-9\\&%_\\./-~-]*)?)?$";
	

}
