/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.common.base;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BeanAttrFilterUtils {
    public static Map<String, Object> extractAttrFromPojo(Object target, String ... targetFields) {
        if (null == target || null == targetFields || 0 == targetFields.length) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        for (String targetField : targetFields) {
            Class<?> targetClass = target.getClass();
            try {
                Field field = targetClass.getDeclaredField(targetField);
                Object invoke = BeanAttrFilterUtils.invokeGetMethod(target, targetClass, field, targetField);
                objectMap.put(targetField, invoke);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return objectMap;
    }

    public static Map<String, Object> removeAttrFromPojo(Object target, String ... targetFields) {
        if (null == target || null == targetFields || 0 == targetFields.length) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        Class<?> targetClass = target.getClass();
        Field[] fields = targetClass.getDeclaredFields();
        List<String> listStrings = Arrays.asList(targetFields);
        for (Field field : fields) {
            String targetField = field.getName();
            String s = listStrings.stream().filter(v -> v.equals(targetField)).findFirst().orElse(null);
            if (s != null) continue;
            try {
                Object invoke = BeanAttrFilterUtils.invokeGetMethod(target, targetClass, field, targetField);
                objectMap.put(targetField, invoke);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return objectMap;
    }

    public static void removeValueForCollection(Collection<?> targets, String ... targetFields) {
        if (Objects.nonNull(targets) && targetFields.length > 0) {
            for (Object target : targets) {
                BeanAttrFilterUtils.removeValueFormPojo(target, targetFields);
            }
        }
    }

    public static void removeValueFormPojo(Object target, String ... targetFields) {
        if (Objects.nonNull(target) && targetFields.length > 0) {
            Class<?> targetClass = target.getClass();
            Field[] fields = targetClass.getDeclaredFields();
            List<String> fieldNames = Arrays.asList(targetFields);
            for (Field field : fields) {
                String s = fieldNames.stream().filter(o -> Objects.equals(o, field.getName())).findFirst().orElse(null);
                if (!Objects.nonNull(s)) continue;
                try {
                    BeanAttrFilterUtils.invokeSetMethod(target, targetClass, field, s, null);
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        }
    }

    private static Object invokeGetMethod(Object target, Class<?> targetClass, Field field, String targetField) throws IllegalAccessException, InvocationTargetException, IntrospectionException {
        PropertyDescriptor pd = new PropertyDescriptor(field.getName(), targetClass);
        Method readMethod = pd.getReadMethod();
        Object invoke = readMethod.invoke(target, new Object[0]);
        return invoke;
    }

    private static void invokeSetMethod(Object target, Class<?> targetClass, Field field, String targetField, Object targetValue) throws IllegalAccessException, InvocationTargetException, IntrospectionException {
        if (!field.getType().getName().equals("boolean")) {
            PropertyDescriptor pd = new PropertyDescriptor(field.getName(), targetClass);
            Method writeMethod = pd.getWriteMethod();
            writeMethod.invoke(target, targetValue);
        }
    }

    public static List<Map<String, Object>> removeAttrForCollection(Collection<?> targets, String ... targetFields) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (Objects.nonNull(targets) && targetFields.length > 0) {
            for (Object target : targets) {
                result.add(BeanAttrFilterUtils.removeAttrFromPojo(target, targetFields));
            }
        }
        return result;
    }

    public static List<Map<String, Object>> extractAttrForCollection(Collection<?> targets, String ... targetFields) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (Objects.nonNull(targets) && targetFields.length > 0) {
            for (Object target : targets) {
                result.add(BeanAttrFilterUtils.extractAttrFromPojo(target, targetFields));
            }
        }
        return result;
    }
}

