package net.ifok.common.hardware;

import com.sun.management.OperatingSystemMXBean;

import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class HardwareUtils {
    /**
     * 获取系统名称
     * @return
     */
    public static String getOsName(){
       return System.getProperty("os.name");
    }

    public static Long totalMemorySize(){
        OperatingSystemMXBean systemMXBean = (OperatingSystemMXBean) ManagementFactory.getOperatingSystemMXBean();
        //b
        long totalMemory =systemMXBean.getTotalPhysicalMemorySize();
        return totalMemory;
    }
    public static Double totalMemorySizeMB(){
        Double intValue = new BigDecimal(totalMemorySize()).divide(new BigDecimal(1024*1024),0,RoundingMode.HALF_UP).setScale(0).doubleValue();
        return intValue;
    }
    public static Double totalMemorySizeGB(){
        Double intValue = new BigDecimal(totalMemorySize()).divide(new BigDecimal(1024*1024*1024),1,RoundingMode.HALF_UP).doubleValue();
        return intValue;
    }


    public static Double memoryFreeRate(){
        OperatingSystemMXBean systemMXBean = (OperatingSystemMXBean) ManagementFactory.getOperatingSystemMXBean();
        long totalPhysicalMemorySize = systemMXBean.getTotalPhysicalMemorySize();
        long freePhysicalMemorySize = systemMXBean.getFreePhysicalMemorySize();
        double v = new BigDecimal(freePhysicalMemorySize).divide(new BigDecimal(totalPhysicalMemorySize), 2, RoundingMode.HALF_UP).doubleValue();
        return v;
    }
    public static Double memoryUseRate(){
        return 1-memoryFreeRate();
    }

    /**
     * cpu使用率
     * @return
     */
    public static Double cpuUseRate(){
        OperatingSystemMXBean systemMXBean = (OperatingSystemMXBean) ManagementFactory.getOperatingSystemMXBean();
        double systemCpuLoad = systemMXBean.getSystemCpuLoad();
        return systemCpuLoad;
    }

    public static void main(String[] args) throws InterruptedException {
        System.out.println(totalMemorySizeGB());
        System.out.println(memoryFreeRate());
        System.out.println(memoryUseRate());
        while (true){
            Thread.sleep(600);
            cpuUseRate();
        }
    }
}
