/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.common.hardware;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Scanner;
import net.ifok.common.string.StringUtils;

public class WindowsHardWareUtils {
    public static String getMotherboardSN() {
        String result = "";
        try {
            File file = File.createTempFile("MotherboardSN", ".vbs");
            file.deleteOnExit();
            try (FileWriter fw = new FileWriter(file);){
                String vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _ \n (\"Select * from Win32_BaseBoard\") \nFor Each objItem in colItems \n Wscript.Echo objItem.SerialNumber \n exit for ' do the first cpu only! \nNext \n";
                fw.write(vbs);
                fw.flush();
            }
            String path = file.getPath().replace("%20", " ");
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + path);
            try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String line;
                while ((line = input.readLine()) != null) {
                    result = result + line;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.trim();
    }

    public static String getMotherboardProduct() {
        String result = "";
        try {
            Process process = Runtime.getRuntime().exec("wmic Baseboard get  Product");
            process.getOutputStream().close();
            try (Scanner scanner = new Scanner(process.getInputStream());){
                if (scanner.hasNext()) {
                    String key = scanner.next();
                    while (scanner.hasNext()) {
                        result = result + scanner.next() + " ";
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.trim();
    }

    public static String getMotherboardCompany() {
        String result = "";
        try {
            Process process = Runtime.getRuntime().exec("wmic Baseboard get  Manufacturer");
            process.getOutputStream().close();
            try (Scanner scanner = new Scanner(process.getInputStream());){
                if (scanner.hasNext()) {
                    String key = scanner.next();
                    while (scanner.hasNext()) {
                        result = result + scanner.next() + " ";
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.trim();
    }

    public static String getHardDiskSN(String drive) {
        String result = "";
        try {
            File file = File.createTempFile("HardDiskSN", ".vbs");
            file.deleteOnExit();
            try (FileWriter fw = new FileWriter(file);){
                String vbs = "Set objFSO = CreateObject(\"Scripting.FileSystemObject\")\nSet colDrives = objFSO.Drives\nSet objDrive = colDrives.item(\"" + drive + "\")\nWscript.Echo objDrive.SerialNumber";
                fw.write(vbs);
            }
            String path = file.getPath().replace("%20", " ");
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + path);
            try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String line;
                while ((line = input.readLine()) != null) {
                    result = result + line;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.trim();
    }

    public static String getCPUSerial() {
        String result = "";
        try {
            Process process = Runtime.getRuntime().exec("wmic cpu get ProcessorId");
            process.getOutputStream().close();
            try (Scanner scanner = new Scanner(process.getInputStream());){
                String key = scanner.next();
                while (scanner.hasNext()) {
                    result = result + scanner.next() + " ";
                }
            }
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
        return result.trim();
    }

    public static String getCpuName() {
        String result = "";
        try {
            Process process = Runtime.getRuntime().exec("wmic cpu get name");
            process.getOutputStream().close();
            try (Scanner scanner = new Scanner(process.getInputStream());){
                String key = scanner.next();
                while (scanner.hasNext()) {
                    result = result + scanner.next() + " ";
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.trim();
    }

    public static String getMac() {
        String result = "";
        try {
            String line;
            Process process = Runtime.getRuntime().exec("ipconfig /all");
            InputStreamReader ir = new InputStreamReader(process.getInputStream(), Charset.forName("GBK"));
            LineNumberReader input = new LineNumberReader(ir);
            while ((line = input.readLine()) != null) {
                String MACAddr;
                if (line.indexOf("Physical Address") <= 0 && line.indexOf("\u7269\u7406\u5730\u5740") <= 0) continue;
                result = MACAddr = line.substring(line.indexOf("-") - 2);
                break;
            }
        }
        catch (IOException e) {
            System.err.println("IOException " + e.getMessage());
        }
        return result;
    }

    public static String getHostName() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Double getMemorySize() {
        try {
            String result = "";
            Process process = Runtime.getRuntime().exec("wmic memorychip get capacity");
            process.getOutputStream().close();
            try (Scanner scanner = new Scanner(process.getInputStream());){
                String key = scanner.next();
                BigDecimal total = new BigDecimal(0);
                while (scanner.hasNext()) {
                    String tx = scanner.next().trim();
                    if (!StringUtils.isNotEmpty(tx)) continue;
                    total = total.add(new BigDecimal(tx));
                }
                Double d = total.doubleValue();
                return d;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static Double getMemorySizeGB() {
        Double memorySize = WindowsHardWareUtils.getMemorySize();
        if (memorySize > 0.0) {
            return new BigDecimal(memorySize).divide(new BigDecimal(0x40000000), 1, RoundingMode.HALF_UP).doubleValue();
        }
        return memorySize;
    }

    public static void main(String[] args) throws UnknownHostException {
        System.out.println("CPU  SN:" + WindowsHardWareUtils.getCPUSerial());
        System.out.println("CPU Name:" + WindowsHardWareUtils.getCpuName());
        System.out.println("Mem :" + WindowsHardWareUtils.getMemorySizeGB());
        System.out.println("\u4e3b\u677f  SN:" + WindowsHardWareUtils.getMotherboardSN());
        System.out.println("\u4e3b\u677f \u578b\u53f7\uff1a" + WindowsHardWareUtils.getMotherboardProduct());
        System.out.println("\u4e3b\u677f \u5382\u5546\uff1a" + WindowsHardWareUtils.getMotherboardCompany());
        System.out.println("C\u76d8   SN:" + WindowsHardWareUtils.getHardDiskSN("c"));
        System.out.println("MAC  SN:" + WindowsHardWareUtils.getMac());
        InetAddress addr = InetAddress.getLocalHost();
        System.out.println("IP\u5730\u5740\uff1a" + addr.getHostAddress() + "\n\u4e3b\u673a\u540d\uff1a" + addr.getHostName());
    }
}

