/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.common.hardware;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class HardwareUtils {
    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static Long totalMemorySize() {
        OperatingSystemMXBean systemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long totalMemory = systemMXBean.getTotalPhysicalMemorySize();
        return totalMemory;
    }

    public static Double totalMemorySizeMB() {
        Double intValue = new BigDecimal(HardwareUtils.totalMemorySize()).divide(new BigDecimal(0x100000), 0, RoundingMode.HALF_UP).setScale(0).doubleValue();
        return intValue;
    }

    public static Double totalMemorySizeGB() {
        Double intValue = new BigDecimal(HardwareUtils.totalMemorySize()).divide(new BigDecimal(0x40000000), 1, RoundingMode.HALF_UP).doubleValue();
        return intValue;
    }

    public static Double memoryFreeRate() {
        OperatingSystemMXBean systemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long totalPhysicalMemorySize = systemMXBean.getTotalPhysicalMemorySize();
        long freePhysicalMemorySize = systemMXBean.getFreePhysicalMemorySize();
        double v = new BigDecimal(freePhysicalMemorySize).divide(new BigDecimal(totalPhysicalMemorySize), 2, RoundingMode.HALF_UP).doubleValue();
        return v;
    }

    public static Double memoryUseRate() {
        return 1.0 - HardwareUtils.memoryFreeRate();
    }

    public static Double cpuUseRate() {
        OperatingSystemMXBean systemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        double systemCpuLoad = systemMXBean.getSystemCpuLoad();
        return systemCpuLoad;
    }

    public static void main(String[] args) throws InterruptedException {
        System.out.println(HardwareUtils.totalMemorySizeGB());
        System.out.println(HardwareUtils.memoryFreeRate());
        System.out.println(HardwareUtils.memoryUseRate());
        while (true) {
            Thread.sleep(600L);
            HardwareUtils.cpuUseRate();
        }
    }
}

