package net.ifok.common.string;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @Description:  字符串工具类
 * @Author: xq
 * @Date: 2021/5/26 10:01
 **/
public class StringUtils {
    private StringUtils(){}

    /**
     * 判断字符为空
     * @param str
     * @return
     */
    public static boolean isEmpty(String str){
        if (Objects.isNull(str)){
            return true;
        }
        if (Objects.equals("",str)){
            return true;
        }
        return false;
    }

    /**
     * 判断字符不为空
     * @param str
     * @return
     */
    public static boolean isNotEmpty(String str){
        return  !isEmpty(str);
    }

    /**
     * 不区分大小写替换字符串
     * @param source 源字符串
     * @param regex 替换表达式
     * @param replacement 替换的新字符串
     * @return 处理后的字符串
     */
    public static String replaceIgnoreCase(String source, String regex,String replacement){
        Pattern p = Pattern.compile(regex, Pattern.CASE_INSENSITIVE);
        Matcher m = p.matcher(source);
        String ret=m.replaceAll(replacement);
        return ret;
    }
}
