package net.ifok.common.security;
import net.ifok.common.io.BytesUtils;
import org.apache.commons.codec.binary.Hex;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * @Description:  MD5 utils
 * @Author: xq
 * @Date: 2021/1/17 21:39
 **/
public class Md5Utils {
    /**
     *
     * <pre>
     * [Summary]
     * 获取MD5实例
     * [Detail]
     * 获取MD5实例
     * [Dependencies]
     *
     * [Author]
     * Xqlee
     * </pre>
     *
     * @return MD5摘要算法实例
     * @throws NoSuchAlgorithmException
     *             异常
     */
    private static final MessageDigest createMessageDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("MD5");
    }

    /**
     *
     * <pre>
     * [Summary]
     * TODO
     * [Detail]
     * TODO
     * [Dependencies]
     *
     * [Author]
     *
     * </pre>
     *
     * @param bin
     * @return
     * @throws NoSuchAlgorithmException
     */
    public synchronized static final byte[] enCode(byte[] bin) throws NoSuchAlgorithmException {
        return createMessageDigest().digest(bin);
    }

    /**
     *
     * <pre>
     * [Summary]
     * 文本的MD5到十六进制字符串
     * [Detail]
     * 文本的MD5到十六进制字符串
     * [Dependencies]
     *
     * [Author]
     * Xqlee
     * </pre>
     *
     * @param text
     *            给定的文本
     * @return 计算的摘要串
     * @throws UnsupportedEncodingException
     *             异常
     * @throws NoSuchAlgorithmException
     *             异常
     */
    public static final String md5(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return md5(text, "UTF-8");
    }

    /**
     *
     * <pre>
     * [Summary]
     * 计算给定的文本的MD5摘要串
     * [Detail]
     * 计算给定的文本的MD5摘要串
     * [Dependencies]
     *
     * [Author]
     *
     * </pre>
     *
     * @param text
     *            给定的文本串
     * @param charset
     *            字符集编码
     * @return MD5摘要值
     * @throws UnsupportedEncodingException
     *             异常
     * @throws NoSuchAlgorithmException
     *             异常
     */
    public static final String md5(String text, String charset)
            throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return BytesUtils.binToHex(enCode(text.getBytes(charset == null ? "UTF-8" : charset)));

    }

    /**
     *
     * <pre>
     * [Summary]
     * 计算文件MD5值
     * [Detail]
     * 计算文件MD5值
     * [Dependencies]
     *
     * [Author]
     * XQLEE
     * </pre>
     *
     * @param file
     *            待计算的文件
     * @return 文件的MD5摘要值
     * @throws IOException
     *             IO异常
     * @throws NoSuchAlgorithmException
     *             MD5工具异常
     */
    public static String getMd5ForFile(File file) throws IOException, NoSuchAlgorithmException {
        try( FileInputStream fileInputStream = new FileInputStream(file);) {
            MessageDigest MD5 = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            int length;
            while ((length = fileInputStream.read(buffer)) != -1) {
                MD5.update(buffer, 0, length);
            }
            return new String(Hex.encodeHex(MD5.digest()));
        }
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        System.out.println(md5("30224.."));
    }
}
