package net.ifok.common.hardware;

import net.ifok.common.string.StringUtils;

import java.io.*;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Scanner;

public class WindowsHardWareUtils {

    /**
     * 获取主板序列号
     *
     * @return
     */
    public static String getMotherboardSN() {
        String result = "";
        try {
            File file = File.createTempFile("MotherboardSN", ".vbs");
            file.deleteOnExit();
            try (FileWriter fw = new FileWriter(file);){
                String vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\n"
                        + "Set colItems = objWMIService.ExecQuery _ \n"
                        + " (\"Select * from Win32_BaseBoard\") \n"
                        + "For Each objItem in colItems \n"
                        + " Wscript.Echo objItem.SerialNumber \n"
                        + " exit for ' do the first cpu only! \n" + "Next \n";

                fw.write(vbs);
                fw.flush();

            }
            String path = file.getPath().replace("%20", " ");
            Process p = Runtime.getRuntime().exec(
                    "cscript //NoLogo " + path);
            try (BufferedReader input = new BufferedReader(new InputStreamReader(
                    p.getInputStream()))){
                String line;
                while ((line = input.readLine()) != null) {
                    result += line;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result.trim();
    }

    public static String getMotherboardProduct(){
        String result = "";
        try {
            Process process=Runtime.getRuntime().exec("wmic Baseboard get  Product");
            process.getOutputStream().close();
            try (Scanner scanner=new Scanner(process.getInputStream());){
                if (scanner.hasNext()){
                    String key=scanner.next();
                    while (scanner.hasNext()){
                        result+=scanner.next()+" ";
                    }
                }
            }
        }catch (IOException e){

        }
        return result.trim();
    }

    public static String getMotherboardCompany(){
        String result = "";
        try {
            Process process=Runtime.getRuntime().exec("wmic Baseboard get  Manufacturer");
            process.getOutputStream().close();
            try (Scanner scanner=new Scanner(process.getInputStream());){
                if (scanner.hasNext()){
                    String key=scanner.next();
                    while (scanner.hasNext()){
                        result+=scanner.next()+" ";
                    }
                }
            }
        }catch (IOException e){

        }
        return result.trim();
    }
    /**
     * 获取硬盘序列号
     *
     * @param drive
     *            盘符
     * @return
     */
    public static String getHardDiskSN(String drive) {
        String result = "";
        try {
            File file = File.createTempFile("HardDiskSN", ".vbs");
            file.deleteOnExit();
           try ( FileWriter fw = new FileWriter(file);){
               String vbs = "Set objFSO = CreateObject(\"Scripting.FileSystemObject\")\n"
                       + "Set colDrives = objFSO.Drives\n"
                       + "Set objDrive = colDrives.item(\""
                       + drive
                       + "\")\n"
                       + "Wscript.Echo objDrive.SerialNumber"; // see note
               fw.write(vbs);
           }
            String path = file.getPath().replace("%20", " ");
            Process p = Runtime.getRuntime().exec(
                    "cscript //NoLogo " + path);
            try (BufferedReader input = new BufferedReader(new InputStreamReader(
                    p.getInputStream()));){
                String line;
                while ((line = input.readLine()) != null) {
                    result += line;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result.trim();
    }

    /**
     * 获取CPU id序列号
     *
     * @return
     */
    public static String getCPUSerial() {
        String result = "";
        try {
            Process process=Runtime.getRuntime().exec("wmic cpu get ProcessorId");
            process.getOutputStream().close();
            try (Scanner scanner=new Scanner(process.getInputStream());){
                String key=scanner.next();
                while (scanner.hasNext()){
                    result+=scanner.next()+" ";
                }
            }
        } catch (Exception e) {
            e.fillInStackTrace();
        }
        return result.trim();
    }

    /**
     * 获取cpuName
     * @return
     */
    public static String getCpuName(){
        String result = "";
        try {
            Process process=Runtime.getRuntime().exec("wmic cpu get name");
            process.getOutputStream().close();
            try (Scanner scanner=new Scanner(process.getInputStream());){
                String key=scanner.next();
                while (scanner.hasNext()){
                    result+=scanner.next()+" ";
                }
            }
        }catch (IOException e){

        }
        return result.trim();
    }

    /**
     * 获取MAC地址 第一张网卡地址
     */
    public static String getMac() {
        String result = "";
        try {

            Process process = Runtime.getRuntime().exec("ipconfig /all");

            InputStreamReader ir = new InputStreamReader(
                    process.getInputStream(),Charset.forName("GBK"));

            LineNumberReader input = new LineNumberReader(ir);

            String line;

            while ((line = input.readLine()) != null){
                if (line.indexOf("Physical Address") > 0||line.indexOf("物理地址")>0) {

                    String MACAddr = line.substring(line.indexOf("-") - 2);

                    result = MACAddr;
                    break;

                }
            }

        } catch (IOException e) {

            System.err.println("IOException " + e.getMessage());

        }
        return result;
    }

    /**
     * 获取主机名称（注意不是电脑型号主机名称可以通过操作系统更改的）
     * @return
     */
    public static String getHostName(){
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }catch (Exception e){
            System.err.println(e.getLocalizedMessage());
            return "";
        }
    }

    public static Double getMemorySize(){
        try {
            String result="";
            Process process=Runtime.getRuntime().exec("wmic memorychip get capacity");
            process.getOutputStream().close();
            try (Scanner scanner=new Scanner(process.getInputStream());){
                String key=scanner.next();
                BigDecimal total=new BigDecimal(0);
                while (scanner.hasNext()){
                    String tx=scanner.next().trim();
                    if (StringUtils.isNotEmpty(tx)){
                        total=total.add(new BigDecimal(tx));
                    }
                }
                return total.doubleValue();
            }
        }catch (IOException e){
            e.printStackTrace();
        }
        return 0.0;
    }

    public static Double getMemorySizeGB(){
        Double memorySize = getMemorySize();
        if (memorySize>0){
            return new BigDecimal(memorySize).divide(new BigDecimal(1024*1024*1024),1, RoundingMode.HALF_UP).doubleValue();
        }
        return memorySize;
    }

    public static void main(String[] args) throws UnknownHostException {
        System.out.println("CPU  SN:" + WindowsHardWareUtils.getCPUSerial());
        System.out.println("CPU Name:"+getCpuName());
        System.out.println("Mem :"+getMemorySizeGB());
        System.out.println("主板  SN:" + WindowsHardWareUtils.getMotherboardSN());
        System.out.println("主板 型号："+getMotherboardProduct());
        System.out.println("主板 厂商："+getMotherboardCompany());
        System.out.println("C盘   SN:" + WindowsHardWareUtils.getHardDiskSN("c"));
        System.out.println("MAC  SN:" + WindowsHardWareUtils.getMac());

        InetAddress addr = InetAddress.getLocalHost();
        System.out.println("IP地址：" + addr.getHostAddress() + "\n主机名：" + addr.getHostName());

        //wmic diskdrive get serialnumber
        //wmic diskdrive where index=0 get serialnumber //第一个硬盘序列号
        //wmic Baseboard get  Manufacturer //主板-厂家
        //wmic Baseboard get  Product //主板-产品型号
        //wmic Baseboard get  SerialNumber //主板-序列号
        // wmic memorychip get capacity //内存大小Byte

    }
}
