/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.common.security;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class DesUtils {
    static final String default_transformation = "DES/ECB/PKCS5Padding";

    private static Cipher getEncryptCipher(byte[] keyData) throws Exception {
        if (keyData.length != 8) {
            throw new Exception("Key Data Must 8 byte!");
        }
        SecretKeySpec key = new SecretKeySpec(keyData, "DES");
        Cipher encryptCipher = Cipher.getInstance(default_transformation);
        encryptCipher.init(1, key);
        return encryptCipher;
    }

    private static Cipher getDecryptCipher(byte[] keyData) throws Exception {
        if (keyData.length != 8) {
            throw new Exception("Key Data Must 8 byte!");
        }
        SecretKeySpec key = new SecretKeySpec(keyData, "DES");
        Cipher decryptCipher = Cipher.getInstance(default_transformation);
        decryptCipher.init(2, key);
        return decryptCipher;
    }

    public static byte[] encrypt(byte[] data, byte[] keyData) throws Exception {
        return DesUtils.getEncryptCipher(keyData).doFinal(data);
    }

    public static byte[] decrypt(byte[] data, byte[] keyData) throws Exception {
        return DesUtils.getDecryptCipher(keyData).doFinal(data);
    }

    public static void main(String[] args) {
        try {
            byte[] data = "\u6d4b\u8bd5123456".getBytes();
            byte[] keyData = "12345678".getBytes();
            System.out.println("\u539f\u6587:" + new String(data));
            byte[] enData = DesUtils.encrypt(data, keyData);
            System.out.println("\u52a0\u5bc6\u540e:" + new String(enData));
            byte[] deData = DesUtils.decrypt(enData, keyData);
            System.out.println("\u89e3\u5bc6\u540e:" + new String(deData));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

