/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.common.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ifok.common.io.IOUtils;
import net.ifok.common.net.model.HttpResponse;
import net.ifok.common.string.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientUtils {
    private static CloseableHttpClient singletonHttpClient = null;
    private static PoolingHttpClientConnectionManager cm;
    private static HttpClient httpClient;
    private static final int MAX_SOCKET_TIMEOUT = 60000;
    private static final int MAX_CONNECTION_TIMEOUT = 60000;
    private static final RequestConfig DEFAULT_CONFIG;

    private HttpClientUtils() {
    }

    public static synchronized HttpClient getHttpClient() throws IOException {
        return singletonHttpClient;
    }

    public static HttpResponse doPost(String url, String bodyJsonParams, Map<String, String> headers, int timeoutSec) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json");
        httpPost.setEntity((HttpEntity)new StringEntity(bodyJsonParams, Charset.forName("UTF-8")));
        HttpClientUtils.addHeader((HttpUriRequest)httpPost, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpPost, config);
    }

    public static HttpResponse doPost(String url, String bodyJsonParams, Map<String, String> headers, int timeoutSec, String proxyHost, Integer proxyPort, String proxyScheme) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).setProxy(HttpClientUtils.getProxy(proxyHost, proxyPort, proxyScheme)).build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json");
        httpPost.setEntity((HttpEntity)new StringEntity(bodyJsonParams, Charset.forName("UTF-8")));
        HttpClientUtils.addHeader((HttpUriRequest)httpPost, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpPost, config);
    }

    public static HttpResponse doPost(String url, String bodyJsonParams, Map<String, String> headers) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json");
        httpPost.setEntity((HttpEntity)new StringEntity(bodyJsonParams, Charset.forName("UTF-8")));
        HttpClientUtils.addHeader((HttpUriRequest)httpPost, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpPost);
    }

    public static HttpResponse doPost(String url, Map<String, String> params, Map<String, String> headers, int timeoutSec) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).build();
        HttpPost httpPost = new HttpPost(url);
        if (params != null && params.keySet().isEmpty()) {
            httpPost.setEntity((HttpEntity)HttpClientUtils.getUrlEncodedFormEntity(params));
        }
        HttpClientUtils.addHeader((HttpUriRequest)httpPost, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpPost, config);
    }

    public static HttpResponse doPost(String url, Map<String, String> params, Map<String, String> headers, int timeoutSec, String proxyHost, Integer proxyPort, String proxyScheme) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).setProxy(HttpClientUtils.getProxy(proxyHost, proxyPort, proxyScheme)).build();
        HttpPost httpPost = new HttpPost(url);
        if (params != null && params.keySet().isEmpty()) {
            httpPost.setEntity((HttpEntity)HttpClientUtils.getUrlEncodedFormEntity(params));
        }
        HttpClientUtils.addHeader((HttpUriRequest)httpPost, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpPost, config);
    }

    public static HttpResponse doPost(String url, Map<String, String> params, Map<String, String> headers) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        if (params != null && params.keySet().isEmpty()) {
            httpPost.setEntity((HttpEntity)HttpClientUtils.getUrlEncodedFormEntity(params));
        }
        HttpClientUtils.addHeader((HttpUriRequest)httpPost, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpPost);
    }

    public static HttpResponse doPatch(String url, String bodyJsonParams, Map<String, String> headers) throws IOException {
        HttpPatch httpPatch = new HttpPatch(url);
        httpPatch.setEntity((HttpEntity)new StringEntity(bodyJsonParams));
        HttpClientUtils.addHeader((HttpUriRequest)httpPatch, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpPatch);
    }

    public static HttpResponse doPatch(String url, String bodyJsonParams, Map<String, String> headers, int timeoutSec) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).build();
        HttpPatch httpPatch = new HttpPatch(url);
        httpPatch.setEntity((HttpEntity)new StringEntity(bodyJsonParams));
        HttpClientUtils.addHeader((HttpUriRequest)httpPatch, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpPatch, config);
    }

    public static HttpResponse doPatch(String url, String bodyJsonParams, Map<String, String> headers, int timeoutSec, String proxyHost, Integer proxyPort, String proxyScheme) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).setProxy(HttpClientUtils.getProxy(proxyHost, proxyPort, proxyScheme)).build();
        HttpPatch httpPatch = new HttpPatch(url);
        httpPatch.setEntity((HttpEntity)new StringEntity(bodyJsonParams));
        HttpClientUtils.addHeader((HttpUriRequest)httpPatch, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpPatch, config);
    }

    public static HttpResponse doPatch(String url, Map<String, String> params, Map<String, String> headers) throws IOException {
        HttpPatch httpPatch = new HttpPatch(url);
        if (params != null && !params.isEmpty()) {
            httpPatch.setEntity((HttpEntity)HttpClientUtils.getUrlEncodedFormEntity(params));
        }
        HttpClientUtils.addHeader((HttpUriRequest)httpPatch, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpPatch);
    }

    public static HttpResponse doPatch(String url, Map<String, String> params, Map<String, String> headers, int timeoutSec) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).build();
        HttpPatch httpPatch = new HttpPatch(url);
        if (params != null && !params.isEmpty()) {
            httpPatch.setEntity((HttpEntity)HttpClientUtils.getUrlEncodedFormEntity(params));
        }
        HttpClientUtils.addHeader((HttpUriRequest)httpPatch, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpPatch, config);
    }

    public static HttpResponse doPatch(String url, Map<String, String> params, Map<String, String> headers, int timeoutSec, String proxyHost, Integer proxyPort, String proxyScheme) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).setProxy(HttpClientUtils.getProxy(proxyHost, proxyPort, proxyScheme)).build();
        HttpPatch httpPatch = new HttpPatch(url);
        if (params != null && !params.isEmpty()) {
            httpPatch.setEntity((HttpEntity)HttpClientUtils.getUrlEncodedFormEntity(params));
        }
        HttpClientUtils.addHeader((HttpUriRequest)httpPatch, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpPatch, config);
    }

    public static HttpResponse doPut(String url, String bodyJsonParams, Map<String, String> headers) throws IOException {
        HttpPut httpPut = new HttpPut(url);
        httpPut.addHeader("Content-Type", "application/json");
        httpPut.setEntity((HttpEntity)new StringEntity(bodyJsonParams, Charset.forName("UTF-8")));
        HttpClientUtils.addHeader((HttpUriRequest)httpPut, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpPut);
    }

    public static HttpResponse doPut(String url, String bodyJsonParams, Map<String, String> headers, int timeoutSec) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).build();
        HttpPut httpPut = new HttpPut(url);
        httpPut.addHeader("Content-Type", "application/json");
        httpPut.setEntity((HttpEntity)new StringEntity(bodyJsonParams, Charset.forName("UTF-8")));
        HttpClientUtils.addHeader((HttpUriRequest)httpPut, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpPut, config);
    }

    public static HttpResponse doPut(String url, String bodyJsonParams, Map<String, String> headers, int timeoutSec, String proxyHost, Integer proxyPort, String proxyScheme) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).setProxy(HttpClientUtils.getProxy(proxyHost, proxyPort, proxyScheme)).build();
        HttpPut httpPut = new HttpPut(url);
        httpPut.addHeader("Content-Type", "application/json");
        httpPut.setEntity((HttpEntity)new StringEntity(bodyJsonParams, Charset.forName("UTF-8")));
        HttpClientUtils.addHeader((HttpUriRequest)httpPut, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpPut, config);
    }

    public static HttpResponse doPut(String url, Map<String, String> params, Map<String, String> headers) throws IOException {
        HttpPut httpPut = new HttpPut(url);
        if (params != null && params.keySet().isEmpty()) {
            httpPut.setEntity((HttpEntity)HttpClientUtils.getUrlEncodedFormEntity(params));
        }
        HttpClientUtils.addHeader((HttpUriRequest)httpPut, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpPut);
    }

    public static HttpResponse doPut(String url, Map<String, String> params, Map<String, String> headers, int timeoutSec) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).build();
        HttpPut httpPut = new HttpPut(url);
        if (params != null && params.keySet().isEmpty()) {
            httpPut.setEntity((HttpEntity)HttpClientUtils.getUrlEncodedFormEntity(params));
        }
        HttpClientUtils.addHeader((HttpUriRequest)httpPut, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpPut, config);
    }

    public static HttpResponse doPut(String url, Map<String, String> params, Map<String, String> headers, int timeoutSec, String proxyHost, Integer proxyPort, String proxyScheme) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).setProxy(HttpClientUtils.getProxy(proxyHost, proxyPort, proxyScheme)).build();
        HttpPut httpPut = new HttpPut(url);
        if (params != null && params.keySet().isEmpty()) {
            httpPut.setEntity((HttpEntity)HttpClientUtils.getUrlEncodedFormEntity(params));
        }
        HttpClientUtils.addHeader((HttpUriRequest)httpPut, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpPut, config);
    }

    public static HttpResponse doDeletedoPut(String url, String bodyJsonParams, Map<String, String> headers) throws IOException {
        HttpDeleteWithEntity httpDelete = new HttpDeleteWithEntity(url);
        httpDelete.setEntity((HttpEntity)new StringEntity(bodyJsonParams));
        HttpClientUtils.addHeader((HttpUriRequest)httpDelete, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpDelete);
    }

    public static HttpResponse doDeletedoPut(String url, String bodyJsonParams, Map<String, String> headers, int timeoutSec) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).build();
        HttpDeleteWithEntity httpDelete = new HttpDeleteWithEntity(url);
        httpDelete.setEntity((HttpEntity)new StringEntity(bodyJsonParams));
        HttpClientUtils.addHeader((HttpUriRequest)httpDelete, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpDelete, config);
    }

    public static HttpResponse doDeletedoPut(String url, String bodyJsonParams, Map<String, String> headers, int timeoutSec, String proxyHost, Integer proxyPort, String proxyScheme) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).setProxy(HttpClientUtils.getProxy(proxyHost, proxyPort, proxyScheme)).build();
        HttpDeleteWithEntity httpDelete = new HttpDeleteWithEntity(url);
        httpDelete.setEntity((HttpEntity)new StringEntity(bodyJsonParams));
        HttpClientUtils.addHeader((HttpUriRequest)httpDelete, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpDelete, config);
    }

    public static HttpResponse doDelete(String url, Map<String, String> params, Map<String, String> headers) throws IOException {
        HttpDeleteWithEntity httpDelete = new HttpDeleteWithEntity(url);
        HttpClientUtils.addHeader((HttpUriRequest)httpDelete, headers);
        if (params != null && !params.isEmpty()) {
            httpDelete.setEntity((HttpEntity)HttpClientUtils.getUrlEncodedFormEntity(params));
        }
        return HttpClientUtils.execute((HttpRequestBase)httpDelete);
    }

    public static HttpResponse doDelete(String url, Map<String, String> params, Map<String, String> headers, int timeoutSec) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).build();
        HttpDeleteWithEntity httpDelete = new HttpDeleteWithEntity(url);
        HttpClientUtils.addHeader((HttpUriRequest)httpDelete, headers);
        if (params != null && !params.isEmpty()) {
            httpDelete.setEntity((HttpEntity)HttpClientUtils.getUrlEncodedFormEntity(params));
        }
        return HttpClientUtils.execute((HttpRequestBase)httpDelete, config);
    }

    public static HttpResponse doDelete(String url, Map<String, String> params, Map<String, String> headers, int timeoutSec, String proxyHost, Integer proxyPort, String proxyScheme) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).setProxy(HttpClientUtils.getProxy(proxyHost, proxyPort, proxyScheme)).build();
        HttpDeleteWithEntity httpDelete = new HttpDeleteWithEntity(url);
        HttpClientUtils.addHeader((HttpUriRequest)httpDelete, headers);
        if (params != null && !params.isEmpty()) {
            httpDelete.setEntity((HttpEntity)HttpClientUtils.getUrlEncodedFormEntity(params));
        }
        return HttpClientUtils.execute((HttpRequestBase)httpDelete, config);
    }

    public static HttpResponse doOptions(String url, String bodyJsonParams, Map<String, String> headers) throws IOException {
        HttpOptionsWithEntity httpOptions = new HttpOptionsWithEntity(url);
        HttpClientUtils.addHeader((HttpUriRequest)httpOptions, headers);
        httpOptions.setEntity((HttpEntity)new StringEntity(bodyJsonParams));
        return HttpClientUtils.execute((HttpRequestBase)httpOptions);
    }

    public static HttpResponse doOptions(String url, String bodyJsonParams, Map<String, String> headers, int timeoutSec) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).build();
        HttpOptionsWithEntity httpOptions = new HttpOptionsWithEntity(url);
        HttpClientUtils.addHeader((HttpUriRequest)httpOptions, headers);
        httpOptions.setEntity((HttpEntity)new StringEntity(bodyJsonParams));
        return HttpClientUtils.execute((HttpRequestBase)httpOptions, config);
    }

    public static HttpResponse doOptions(String url, String bodyJsonParams, Map<String, String> headers, int timeoutSec, String proxyHost, Integer proxyPort, String proxyScheme) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).setProxy(HttpClientUtils.getProxy(proxyHost, proxyPort, proxyScheme)).build();
        HttpOptionsWithEntity httpOptions = new HttpOptionsWithEntity(url);
        HttpClientUtils.addHeader((HttpUriRequest)httpOptions, headers);
        httpOptions.setEntity((HttpEntity)new StringEntity(bodyJsonParams));
        return HttpClientUtils.execute((HttpRequestBase)httpOptions, config);
    }

    public static HttpResponse doOptions(String url, Map<String, String> params, Map<String, String> headers) throws IOException {
        HttpOptionsWithEntity httpOptions = new HttpOptionsWithEntity(url);
        HttpClientUtils.addHeader((HttpUriRequest)httpOptions, headers);
        if (params != null && !params.isEmpty()) {
            httpOptions.setEntity((HttpEntity)HttpClientUtils.getUrlEncodedFormEntity(params));
        }
        return HttpClientUtils.execute((HttpRequestBase)httpOptions);
    }

    public static HttpResponse doOptions(String url, Map<String, String> params, Map<String, String> headers, int timeoutSec) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).build();
        HttpOptionsWithEntity httpOptions = new HttpOptionsWithEntity(url);
        HttpClientUtils.addHeader((HttpUriRequest)httpOptions, headers);
        if (params != null && !params.isEmpty()) {
            httpOptions.setEntity((HttpEntity)HttpClientUtils.getUrlEncodedFormEntity(params));
        }
        return HttpClientUtils.execute((HttpRequestBase)httpOptions, config);
    }

    public static HttpResponse doOptions(String url, Map<String, String> params, Map<String, String> headers, int timeoutSec, String proxyHost, Integer proxyPort, String proxyScheme) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).setProxy(HttpClientUtils.getProxy(proxyHost, proxyPort, proxyScheme)).build();
        HttpOptionsWithEntity httpOptions = new HttpOptionsWithEntity(url);
        HttpClientUtils.addHeader((HttpUriRequest)httpOptions, headers);
        if (params != null && !params.isEmpty()) {
            httpOptions.setEntity((HttpEntity)HttpClientUtils.getUrlEncodedFormEntity(params));
        }
        return HttpClientUtils.execute((HttpRequestBase)httpOptions, config);
    }

    public static HttpResponse doHeader(String url, Map<String, String> headers) throws IOException {
        HttpHead httpHead = new HttpHead(url);
        HttpClientUtils.addHeader((HttpUriRequest)httpHead, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpHead);
    }

    public static HttpResponse doHeader(String url, Map<String, String> headers, int timeoutSec) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).build();
        HttpHead httpHead = new HttpHead(url);
        HttpClientUtils.addHeader((HttpUriRequest)httpHead, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpHead, config);
    }

    public static HttpResponse doHeader(String url, Map<String, String> headers, int timeoutSec, String proxyHost, Integer proxyPort, String proxyScheme) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).setProxy(HttpClientUtils.getProxy(proxyHost, proxyPort, proxyScheme)).build();
        HttpHead httpHead = new HttpHead(url);
        HttpClientUtils.addHeader((HttpUriRequest)httpHead, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpHead, config);
    }

    public static HttpResponse doGet(String url, Map<String, String> params, Map<String, String> headers) throws IOException {
        return HttpClientUtils.doGet(url, params, headers, 60000);
    }

    public static HttpResponse doGet(String url, Map<String, String> params, Map<String, String> headers, int timeoutSec) throws IOException {
        return HttpClientUtils.doGet(url, params, headers, timeoutSec, null);
    }

    public static HttpResponse doGet(String url, Map<String, String> params, Map<String, String> headers, int timeoutSec, String responseCharset) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).build();
        StringBuilder paramsBuilder = new StringBuilder(url);
        if (params != null && !params.keySet().isEmpty()) {
            if (!url.contains("?")) {
                paramsBuilder.append("?");
            }
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            Set<String> keySet = params.keySet();
            for (String key : keySet) {
                String value = params.get(key);
                list.add(new BasicNameValuePair(key, value));
            }
            String paramsStr = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(list));
            paramsBuilder.append(paramsStr);
        }
        HttpGet httpGet = new HttpGet(paramsBuilder.toString());
        HttpClientUtils.addHeader((HttpUriRequest)httpGet, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpGet, config, responseCharset);
    }

    public static HttpResponse doGet(String url, Map<String, String> params, Map<String, String> headers, int timeoutSec, String proxyHost, Integer proxyPort, String proxyScheme) throws IOException {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).setProxy(HttpClientUtils.getProxy(proxyHost, proxyPort, proxyScheme)).build();
        StringBuilder paramsBuilder = new StringBuilder(url);
        if (params != null && !params.keySet().isEmpty()) {
            if (!url.contains("?")) {
                paramsBuilder.append("?");
            }
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            Set<String> keySet = headers.keySet();
            for (String key : keySet) {
                String value = headers.get(key);
                list.add(new BasicNameValuePair(key, value));
            }
            String paramsStr = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(list));
            paramsBuilder.append(paramsStr);
        }
        HttpGet httpGet = new HttpGet(paramsBuilder.toString());
        HttpClientUtils.addHeader((HttpUriRequest)httpGet, headers);
        return HttpClientUtils.execute((HttpRequestBase)httpGet, config);
    }

    @Deprecated
    public static HttpResponse doGetImg(String url, Map<String, String> params, Map<String, String> headers) throws IOException {
        StringBuilder paramsBuilder = new StringBuilder(url);
        if (params != null && params.keySet().isEmpty()) {
            if (url.indexOf("?") == -1) {
                paramsBuilder.append("?");
            }
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            Set<String> keySet = params.keySet();
            for (String key : keySet) {
                String value = params.get(key);
                list.add(new BasicNameValuePair(key, value));
            }
            String paramsStr = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(list));
            paramsBuilder.append(paramsStr);
        }
        HttpGet httpGet = new HttpGet(paramsBuilder.toString());
        HttpClientUtils.addHeader((HttpUriRequest)httpGet, headers);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            InputStream is = response.getEntity().getContent();
            byte[] imgBytes = IOUtils.inputStream2byte(is);
            HttpResponse httpResponse = new HttpResponse(Base64.getEncoder().encodeToString(imgBytes), response.getStatusLine().getStatusCode());
            return httpResponse;
        }
    }

    public static HttpResponse doGetFile(String url, Map<String, String> params, Map<String, String> headers) throws IOException {
        HttpResponse httpResponse = HttpClientUtils.doGetFile(url, params, headers);
        return httpResponse;
    }

    public static HttpResponse doGetFile(String url, Map<String, String> params, Map<String, String> headers, Integer timeoutSec) throws IOException {
        StringBuilder paramsBuilder = new StringBuilder(url);
        if (params != null && params.keySet().isEmpty()) {
            if (url.indexOf("?") == -1) {
                paramsBuilder.append("?");
            }
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            Set<String> keySet = params.keySet();
            for (String key : keySet) {
                String value = params.get(key);
                list.add(new BasicNameValuePair(key, value));
            }
            String paramsStr = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(list));
            paramsBuilder.append(paramsStr);
        }
        HttpGet httpGet = new HttpGet(paramsBuilder.toString());
        HttpClientUtils.addHeader((HttpUriRequest)httpGet, headers);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            CloseableHttpResponse response;
            if (Objects.nonNull(timeoutSec)) {
                RequestConfig config = RequestConfig.custom().setSocketTimeout(timeoutSec * 1000).setConnectTimeout(timeoutSec * 1000).build();
                httpGet.setConfig(config);
                response = httpClient.execute((HttpUriRequest)httpGet);
            } else {
                httpGet.setConfig(DEFAULT_CONFIG);
                response = httpClient.execute((HttpUriRequest)httpGet);
            }
            InputStream is = response.getEntity().getContent();
            byte[] imgBytes = IOUtils.inputStream2byte(is);
            HttpResponse httpResponse = new HttpResponse(Base64.getEncoder().encodeToString(imgBytes), response.getStatusLine().getStatusCode());
            return httpResponse;
        }
    }

    private static HttpResponse execute(HttpRequestBase httpRequestBase) throws IOException {
        return HttpClientUtils.execute(httpRequestBase, null);
    }

    private static HttpResponse execute(HttpRequestBase httpRequestBase, RequestConfig config) throws IOException {
        return HttpClientUtils.execute(httpRequestBase, config, null);
    }

    private static HttpResponse execute(HttpRequestBase httpRequestBase, RequestConfig config, String responseCharset) throws IOException {
        if (config == null) {
            config = DEFAULT_CONFIG;
        }
        httpRequestBase.setConfig(config);
        HttpClient httpClient = HttpClientUtils.getHttpClient();
        org.apache.http.HttpResponse response = httpClient.execute((HttpUriRequest)httpRequestBase);
        Header type = response.getEntity().getContentType();
        String defaultCharset = "UTF-8";
        String charset = HttpClientUtils.getCharSet(type.getValue());
        if (charset != null && !"".equals(charset)) {
            defaultCharset = charset;
        }
        if (!StringUtils.isEmpty(responseCharset)) {
            defaultCharset = responseCharset;
        }
        return new HttpResponse(EntityUtils.toString((HttpEntity)response.getEntity(), (String)defaultCharset), response.getStatusLine().getStatusCode());
    }

    private static void addHeader(HttpUriRequest httpUriRequest, Map<String, String> headers) {
        if (httpUriRequest != null && headers != null && !headers.keySet().isEmpty()) {
            Set<String> keySet = headers.keySet();
            for (String key : keySet) {
                String value = headers.get(key);
                httpUriRequest.addHeader(key, value);
            }
        }
    }

    private static UrlEncodedFormEntity getUrlEncodedFormEntity(Map<String, String> params) throws UnsupportedEncodingException {
        if (params != null && params.keySet().isEmpty()) {
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            Set<String> keySet = params.keySet();
            for (String key : keySet) {
                String value = params.get(key);
                list.add(new BasicNameValuePair(key, value));
            }
            return new UrlEncodedFormEntity(list);
        }
        return null;
    }

    private static HttpHost getProxy(String proxyHost, Integer proxyPort, String proxyScheme) {
        HttpHost proxy = null;
        if (!StringUtils.isEmpty(proxyHost)) {
            proxy = proxyPort != null && !StringUtils.isEmpty(proxyScheme) ? new HttpHost(proxyHost, proxyPort.intValue(), proxyScheme) : (proxyPort != null && StringUtils.isEmpty(proxyScheme) ? new HttpHost(proxyHost, proxyPort.intValue()) : new HttpHost(proxyHost));
        }
        return proxy;
    }

    private static String getCharSet(String content) {
        String regex = ".*charset=([^;]*).*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String getRedirectURL(String url, Map<String, String> headers) throws IOException {
        RequestConfig requestConfig = RequestConfig.custom().setRedirectsEnabled(false).build();
        try (CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();){
            HttpGet httpGet = new HttpGet(url);
            HttpClientUtils.addHeader((HttpUriRequest)httpGet, headers);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 302) {
                Header location = response.getFirstHeader("location");
                String string = location.getValue();
                return string;
            }
            String string = url;
            return string;
        }
    }

    static {
        httpClient = null;
        DEFAULT_CONFIG = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).build();
        cm = new PoolingHttpClientConnectionManager();
        cm.setDefaultMaxPerRoute(10);
        cm.setMaxTotal(30);
        singletonHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setMaxConnTotal(400).setMaxConnPerRoute(150).setDefaultRequestConfig(DEFAULT_CONFIG).evictExpiredConnections().build();
    }

    static class HttpOptionsWithEntity
    extends HttpEntityEnclosingRequestBase {
        public static final String METHOD_NAME = "OPTIONS";

        public String getMethod() {
            return METHOD_NAME;
        }

        public HttpOptionsWithEntity() {
        }

        public HttpOptionsWithEntity(String uri) {
            this.setURI(URI.create(uri));
        }

        public HttpOptionsWithEntity(URI uri) {
            this.setURI(uri);
        }
    }

    static class HttpDeleteWithEntity
    extends HttpEntityEnclosingRequestBase {
        public static final String METHOD_NAME = "DELETE";

        public String getMethod() {
            return METHOD_NAME;
        }

        public HttpDeleteWithEntity(String uri) {
            this.setURI(URI.create(uri));
        }

        public HttpDeleteWithEntity(URI uri) {
            this.setURI(uri);
        }

        public HttpDeleteWithEntity() {
        }
    }
}

