package net.wysistat.sdk

/**
 * Represents an error in Wysistat SDK
 */
sealed class WysistatError(message: String?, cause: Throwable? = null) : kotlin.Error(message, cause) {
    /** description */
    object NotActivated : Error("SDK is not initialized, please call Wysistat.init(context, account) before use it",null)
    /** description */
    object AlreadyActivated : Error("SDK already activated",null)
}