package net.wysistat.sdk

import retrofit2.Response
import retrofit2.http.HTTP
import retrofit2.http.Header
import retrofit2.http.Path
import retrofit2.http.Query

internal interface WysistatApi {

    @HTTP(method = "GET", path = "images/{account}/compteur.php")
    suspend fun send(
        @Path("account") account: String,
        @Header("Referer") referer: String,
        @Query("nom") name: String,
        @Query("tps") time: String,
        @Query("ecran") widthSize: String,
        @Query("origine") origine: String = "",
        @Query("origine_force") origine_force: String = "",
        @Query("frame") frame: String,
        @Query("ParaWysistat") counterSpecial: String,
        @Query("CompteurExtranet") counterExtranet: String,
        @Query("ParaPage") page: String,
        @Query("ParaProfiling") profil: String,
        @Query("ParaCompte") paraAccount: String,
        @Query("ParaRoi") roi: String,
        @Query("ojd_version") ojdVersion: Int = 2,
        @Query("cookie") cookie: Int = 1,
        @Query("deja_cookie") dejaCookie: Int = 1,
        @Query("version") version: Int = 3,
        @Query("id") idCookie: String,
        @Query("id_int") idCookieInt: String,
        @Query("compteur_mois") counterMonth: Int,
        @Query("compteur_jour") counterDay: Int,
        @Query("deja_id") dejaId: Int,
        @Query("vu_diff_jour") vuDiffJour: Int,
        @Query("vu_time_prec") vuTimePrec: String,
        @Query("page_js") urlWebSite: String,
        @Query("timestamp") timestamp: String? = null,
        @Query("SubAccount") subAccount: String? = null,
    ): Response<Unit>
}