package net.wysistat.sdk

import android.content.Context
import java.io.BufferedReader
import java.io.File
import java.io.FileInputStream
import java.io.FileOutputStream
import java.io.IOException
import java.io.InputStreamReader
import java.io.OutputStreamWriter

internal interface Save {
    fun WriteCookie(context: Context, data: String)
    fun WriteStock(context: Context, data: String)
    fun ReadStock(context: Context?): ArrayList<String>
    fun deleteFile(context: Context)
    fun ReadAndDelete(context: Context, line: String?)
}

internal open class SaveImpl: Save {
    var nomFichier: String

    constructor() {
        nomFichier = "stock.log"
    }

    constructor(nom: String) {
        nomFichier = nom
    }

    override fun WriteCookie(context: Context, data: String) {
        var fOut: FileOutputStream? = null
        var osw: OutputStreamWriter? = null
        try {
            fOut = context.openFileOutput(nomFichier, Context.MODE_PRIVATE)
            osw = OutputStreamWriter(fOut)
            osw.write(
                """
                    $data
                    
                    """.trimIndent()
            )
            osw.flush()
        } catch (e: Exception) {
            // Toast.makeText(context,
            // "Settings not saved",Toast.LENGTH_SHORT).show();
        } finally {
            try {
                osw?.close()
                fOut?.close()
            } catch (e: IOException) {
                // Toast.makeText(context,
                // "Settings not saved",Toast.LENGTH_SHORT).show();
            }
        }
    }

    override fun WriteStock(context: Context, data: String) {
        var fOut: FileOutputStream? = null
        var osw: OutputStreamWriter? = null
        try {
            fOut = context.openFileOutput(nomFichier, Context.MODE_APPEND)
            osw = OutputStreamWriter(fOut)
            osw.write(
                """
                    $data
                    
                    """.trimIndent()
            )
            osw.flush()
        } catch (e: Exception) {
            // Toast.makeText(context,
            // "Settings not saved",Toast.LENGTH_SHORT).show();
        } finally {
            try {
                osw?.close()
                fOut?.close()
            } catch (e: IOException) {
                // Toast.makeText(context,
                // "Settings not saved",Toast.LENGTH_SHORT).show();
            }
        }
    }

    override fun ReadStock(context: Context?): ArrayList<String> {
        var fIn: FileInputStream? = null
        var isr: InputStreamReader? = null

        // char[] inputBuffer = new char[255];
        val tabUrl = ArrayList<String>()

        return if(context != null) {
            val file: File = context.getFileStreamPath(nomFichier)
            if (!file.exists()) {
                tabUrl
            } else try {
                fIn = context.openFileInput(nomFichier)
                isr = InputStreamReader(fIn)
                val buffreader = BufferedReader(isr)
                var thisLine: String
                while (buffreader.readLine().also { thisLine = it } != null) {

                    //Log.e("thisLine", thisLine);
                    tabUrl.add(thisLine)
                }
                tabUrl
            } catch (e: Exception) {
                tabUrl
            }
        } else {
            tabUrl
        }
    }

    override fun deleteFile(context: Context) {
        val file: File = context.getFileStreamPath(nomFichier)

        if (file.exists()) {
            file.delete()
        }
    }

    override fun ReadAndDelete(context: Context, line: String?) {
        var fIn: FileInputStream? = null
        var isr: InputStreamReader? = null
        var chaine = ""
        val file: File = context.getFileStreamPath(nomFichier)
        if (!file.exists()) {
            return
        }
        try {
            fIn = context.openFileInput(nomFichier)
            isr = InputStreamReader(fIn)
            val buffreader = BufferedReader(isr)
            var thisLine: String
            while (buffreader.readLine().also { thisLine = it } != null) {

                //Log.e("thisLine", thisLine);
                if (!thisLine.equals(line, ignoreCase = true)) {
                    chaine += """
                    $thisLine
                    
                    """.trimIndent()
                }
            }
            WriteCookie(context, chaine)
            return
        } catch (e: Exception) {
            return
        }
    }
}