/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.writer;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.object.Result;
import net.ideahut.springboot.util.ReactiveUtil;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMessage;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveDataMapperHttpMessageWriter
implements HttpMessageWriter {
    private final List<MediaType> mimeTypes = Arrays.asList(MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML, MediaType.TEXT_XML);
    private final DataMapper dataMapper;

    public ReactiveDataMapperHttpMessageWriter(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
    }

    public DataMapper getDataMapper() {
        return this.dataMapper;
    }

    public List<MediaType> getWritableMediaTypes() {
        return this.mimeTypes;
    }

    public boolean canWrite(ResolvableType elementType, MediaType mediaType) {
        return true;
    }

    public Mono<Void> write(Publisher inputStream, ResolvableType elementType, @Nullable MediaType mediaType, ReactiveHttpOutputMessage message, Map hints) {
        Long start = ReactiveUtil.Share.getStart((HttpMessage)message);
        boolean reactive = ReactiveUtil.Share.isReactive((HttpMessage)message);
        ReactiveUtil.Share.clear((HttpMessage)message);
        if (reactive) {
            return message.writeWith(inputStream);
        }
        mediaType = mediaType != null && mediaType.toString().indexOf("xml") != -1 ? MediaType.TEXT_XML : MediaType.APPLICATION_JSON;
        message.getHeaders().set("Content-Type", mediaType.toString());
        boolean isXml = MediaType.TEXT_XML == mediaType;
        return Mono.from((Publisher)inputStream).flatMap(object -> {
            Mono body = null;
            if (object instanceof Mono) {
                body = Mono.from((Publisher)((Mono)object)).flatMap(t -> this.createBody(t, message, isXml, start));
            } else if (object instanceof Flux) {
                body = Flux.from((Publisher)((Flux)object)).flatMap(t -> this.createBody(t, message, isXml, start));
            } else if (object instanceof ResponseEntity) {
                ResponseEntity respty = (ResponseEntity)object;
                if (message instanceof ServerHttpResponse) {
                    ServerHttpResponse httpResponse = (ServerHttpResponse)message;
                    httpResponse.setStatusCode(respty.getStatusCode());
                    HttpHeaders httpHeaders = respty.getHeaders();
                    for (Map.Entry entry : httpHeaders.entrySet()) {
                        httpResponse.getHeaders().put((String)entry.getKey(), (List)entry.getValue());
                    }
                }
                body = this.createBody(respty.getBody(), message, isXml, start);
            } else {
                body = this.createBody(object, message, isXml, start);
            }
            return message.writeWith((Publisher)(body != null ? body : Mono.empty()));
        });
    }

    private Publisher createBody(Object object, ReactiveHttpOutputMessage message, boolean isXml, Long start) {
        byte[] bytes;
        if (object != null) {
            if (object instanceof byte[]) {
                bytes = (byte[])object;
            } else {
                Result result = object instanceof Result ? (Result)object : Result.success((Object)object);
                if (start != null) {
                    result.updateTime(Long.valueOf(System.nanoTime() - start));
                } else {
                    result.nullTime();
                }
                bytes = this.dataMapper.writeAsBytes(result, isXml ? 2 : 1);
            }
        } else {
            bytes = new byte[]{};
        }
        return Mono.just((Object)message.bufferFactory().wrap(bytes));
    }
}

