/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.util;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.object.Result;
import net.ideahut.springboot.util.FrameworkUtil;
import net.ideahut.springboot.util.StringUtil;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMessage;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class ReactiveUtil {
    private ReactiveUtil() {
    }

    public static <T> T getContent(Mono<T> mono) {
        try {
            return mono.toFuture().get();
        }
        catch (Exception e) {
            throw FrameworkUtil.exception(e);
        }
    }

    public static byte[] getDataBufferAsBytes(DataBuffer dataBuffer) {
        byte[] bytes = new byte[dataBuffer.readableByteCount()];
        dataBuffer.read(bytes);
        DataBufferUtils.release((DataBuffer)dataBuffer);
        return bytes;
    }

    public static String queryString(MultiValueMap<String, String> params) {
        Object query = "";
        if (params != null) {
            for (Map.Entry entry : params.entrySet()) {
                for (String value : (List)entry.getValue()) {
                    query = (String)query + "&" + URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8) + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8);
                }
            }
            if (((String)query).length() != 0) {
                query = ((String)query).substring(1);
            }
        }
        return query;
    }

    public static Mono<Void> sendToClient(DataMapper dataMapper, ServerWebExchange exchange, Object object) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        byte[] data = null;
        if (object instanceof byte[]) {
            data = (byte[])object;
        } else {
            Long start;
            if (object instanceof Result && (start = Share.getStart((HttpMessage)exchange.getResponse())) != null) {
                ((Result)object).updateTime(Long.valueOf(System.nanoTime() - start));
            }
            String accept = request.getHeaders().getFirst("Accept");
            int mapperType = 1;
            String contentType = "application/json";
            if (accept != null && accept.indexOf("xml") != -1) {
                mapperType = 2;
                contentType = "application/xml";
            }
            data = dataMapper.writeAsBytes(object, mapperType);
            response.getHeaders().set("Content-Type", contentType);
        }
        DataBuffer buffer = response.bufferFactory().wrap(data);
        Share.clear((HttpMessage)exchange.getResponse());
        return response.writeAndFlushWith((Publisher)Mono.just((Object)Mono.just((Object)buffer)));
    }

    public static String getHeader(HttpMessage message, String name, String defaultValue) {
        HttpHeaders headers = message.getHeaders();
        String value = headers.getFirst(name);
        if (value == null && (value = headers.getFirst(name.toLowerCase())) == null) {
            value = headers.getFirst(name.toUpperCase());
        }
        return value != null ? value : defaultValue;
    }

    public static String getHeader(HttpMessage message, String name) {
        return ReactiveUtil.getHeader(message, name, null);
    }

    public static String getRemoteHost(ServerHttpRequest request) {
        String host = ReactiveUtil.getHeader((HttpMessage)request, "X-Forwarded-For", "").trim();
        if (host.isEmpty()) {
            host = request.getRemoteAddress().getAddress().getHostAddress();
        }
        host = host.split("\\,")[0].trim();
        return host;
    }

    public static String getUserAgent(ServerHttpRequest request) {
        return ReactiveUtil.getHeader((HttpMessage)request, "User-Agent", "");
    }

    public static final class Share {
        private static final String START = FrameworkUtil.digest("sha256", "" + System.nanoTime());
        private static final String REACTIVE = FrameworkUtil.digest("sha256", "" + System.nanoTime());
        private static final String LANGUAGE = FrameworkUtil.digest("sha256", "" + System.nanoTime());

        private Share() {
        }

        public static void setStart(HttpMessage message, Long startTime) {
            HttpHeaders headers = message.getHeaders();
            if (!headers.containsKey((Object)START)) {
                headers.set(START, "" + startTime);
            }
        }

        public static void setReactive(HttpMessage message, boolean isReactive) {
            HttpHeaders headers = message.getHeaders();
            if (!headers.containsKey((Object)REACTIVE)) {
                headers.set(REACTIVE, "" + isReactive);
            }
        }

        public static void setLanguage(HttpMessage message, String language) {
            HttpHeaders headers = message.getHeaders();
            if (!headers.containsKey((Object)LANGUAGE)) {
                headers.set(LANGUAGE, language);
            }
        }

        public static void setLanguage(ServerWebExchange exchange) {
            String language = ReactiveUtil.getHeader((HttpMessage)exchange.getRequest(), "Accept-Language", "");
            Share.setLanguage((HttpMessage)exchange.getResponse(), language);
        }

        public static void clear(HttpMessage message) {
            HttpHeaders headers = message.getHeaders();
            headers.remove((Object)START);
            headers.remove((Object)REACTIVE);
            headers.remove((Object)LANGUAGE);
        }

        public static Long getStart(HttpMessage message) {
            return (Long)StringUtil.valueOf(Long.class, (String)ReactiveUtil.getHeader(message, START));
        }

        public static boolean isReactive(HttpMessage message) {
            return (Boolean)StringUtil.valueOf(Boolean.TYPE, (String)ReactiveUtil.getHeader(message, REACTIVE), (Object)false);
        }

        public static String getLanguage(HttpMessage message) {
            return (String)StringUtil.valueOf(String.class, (String)ReactiveUtil.getHeader(message, LANGUAGE));
        }
    }
}

