/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

final class FrameworkUtil0 {
    private static final String[] hibernateClasses = new String[]{"org.hibernate.cfg.AvailableSettings", "org.hibernate.cfg.BatchSettings", "org.hibernate.cfg.BytecodeSettings", "org.hibernate.cfg.CacheSettings", "org.hibernate.cfg.EnvironmentSettings", "org.hibernate.cfg.FetchSettings", "org.hibernate.cfg.JdbcSettings", "org.hibernate.cfg.JpaComplianceSettings", "org.hibernate.cfg.ManagedBeanSettings", "org.hibernate.cfg.MappingSettings", "org.hibernate.cfg.MultiTenancySettings", "org.hibernate.cfg.PersistenceSettings", "org.hibernate.cfg.QuerySettings", "org.hibernate.cfg.SchemaToolingSettings", "org.hibernate.cfg.SessionEventSettings", "org.hibernate.cfg.StatisticsSettings", "org.hibernate.cfg.TransactionSettings", "org.hibernate.cfg.ValidationSettings", "net.ideahut.springboot.entity.EntityIntegrator"};
    private static final Set<String> hibernateKeys;
    private static final Class<?> reactiveGenericClass;
    private static final Method reactiveWebServerMethod;
    private static final Method servletWebServerMethod;

    FrameworkUtil0() {
    }

    protected static void checkRequirement(ApplicationContext applicationContext) {
        Class filterClass;
        boolean filterFound = false;
        if (FrameworkUtil0.isReactive(applicationContext)) {
            filterClass = FrameworkUtil0.getClass("net.ideahut.springboot.filter.ReactiveRequestFilter");
            filterFound = applicationContext.getBean(filterClass) != null;
        } else {
            filterClass = FrameworkUtil0.getClass("net.ideahut.springboot.filter.DefaultRequestFilter");
            Class servletBeanFilter = FrameworkUtil0.getClass("org.springframework.boot.web.servlet.AbstractFilterRegistrationBean");
            Method servletFilterMethod = FrameworkUtil0.getMethod(servletBeanFilter, "getFilter", new Class[0]);
            Map beans = applicationContext.getBeansOfType(servletBeanFilter);
            for (Object bean : beans.values()) {
                Object filter = FrameworkUtil0.invoke(bean, servletFilterMethod, new Object[0]);
                if (filter == null || !filterClass.isAssignableFrom(filter.getClass())) continue;
                filterFound = true;
                break;
            }
        }
        Assert.isTrue((boolean)filterFound, (String)("Unregistered filter: " + filterClass.getName()));
    }

    protected static Set<String> getHibernateKeys() {
        return hibernateKeys;
    }

    protected static boolean isReactive(ApplicationContext applicationContext) {
        return reactiveGenericClass != null && reactiveGenericClass.isAssignableFrom(applicationContext.getClass());
    }

    protected static WebServer getWebServer(ApplicationContext applicationContext) {
        WebServer webServer = FrameworkUtil0.isReactive(applicationContext) ? (WebServer)FrameworkUtil0.invoke(applicationContext, reactiveWebServerMethod, new Object[0]) : (WebServer)FrameworkUtil0.invoke(applicationContext, servletWebServerMethod, new Object[0]);
        return webServer;
    }

    protected static int getPort(ApplicationContext applicationContext) {
        WebServer webServer = FrameworkUtil0.getWebServer(applicationContext);
        return webServer != null ? webServer.getPort() : -1;
    }

    private static <T> Class<T> getClass(String classname) {
        try {
            return Class.forName(classname);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Method getMethod(String classname, String methodname, Class<?> ... parameterTypes) {
        return FrameworkUtil0.getMethod(FrameworkUtil0.getClass(classname), methodname, parameterTypes);
    }

    private static Method getMethod(Class<?> clazz, String methodname, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodname, parameterTypes);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Object invoke(Object object, Method method, Object ... arguments) {
        try {
            return method.invoke(object, arguments);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Set<String> _getHibernateKeys(String classname) {
        HashSet<String> keys = new HashSet<String>();
        try {
            Class<?> clazz = Class.forName(classname);
            for (Field field : clazz.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
                field.setAccessible(true);
                String key = String.valueOf(field.get(null));
                if (!key.startsWith("hibernate.")) continue;
                keys.add(key);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return keys;
    }

    static {
        LinkedHashSet<String> _hibernateKeys = new LinkedHashSet<String>();
        for (String classname : hibernateClasses) {
            Set<String> keys = FrameworkUtil0._getHibernateKeys(classname);
            _hibernateKeys.addAll(keys);
        }
        hibernateKeys = _hibernateKeys;
        reactiveGenericClass = FrameworkUtil0.getClass("org.springframework.boot.web.reactive.context.GenericReactiveWebApplicationContext");
        reactiveWebServerMethod = FrameworkUtil0.getMethod("org.springframework.boot.web.reactive.context.ReactiveWebServerApplicationContext", "getWebServer", new Class[0]);
        servletWebServerMethod = FrameworkUtil0.getMethod("org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext", "getWebServer", new Class[0]);
    }
}

