/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.sysparam;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.sysparam.SysParamDto;
import net.ideahut.springboot.sysparam.SysParamReloader;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

final class SysParamHelper {
    private SysParamHelper() {
    }

    protected static synchronized boolean lock(RedisTemplate<String, byte[]> redisTemplate, String prefix, boolean yes) {
        String lockKey = Key.lock(prefix);
        if (yes) {
            ValueOperations lockOps = redisTemplate.opsForValue();
            byte[] lockBytes = (byte[])lockOps.get((Object)lockKey);
            if (lockBytes != null) {
                return false;
            }
            lockOps.set((Object)lockKey, (Object)"1".getBytes());
        } else {
            redisTemplate.delete((Object)lockKey);
        }
        return true;
    }

    protected static void clear(DataMapper dataMapper, RedisTemplate<String, byte[]> redisTemplate, String prefix) {
        ValueOperations operations = redisTemplate.opsForValue();
        HashSet<String> ckeys = new HashSet<String>();
        String lkey = Key.syscodes(prefix);
        ckeys.add(lkey);
        byte[] bytes = (byte[])operations.get((Object)lkey);
        if (bytes != null) {
            Map<String, Set<String>> sysCodes = dataMapper.read(bytes, TypeRef.SYSCODE_MAP);
            for (Map.Entry<String, Set<String>> entry : sysCodes.entrySet()) {
                ckeys.add(Key.map(prefix, entry.getKey()));
                for (String paramCode : entry.getValue()) {
                    ckeys.add(Key.value(prefix, entry.getKey(), paramCode));
                }
            }
        }
        redisTemplate.delete(ckeys);
    }

    protected static void remove(DataMapper dataMapper, RedisTemplate<String, byte[]> redisTemplate, String prefix, Collection<String> sysCodes) {
        ValueOperations operations = redisTemplate.opsForValue();
        byte[] bytes = (byte[])operations.get((Object)Key.syscodes(prefix));
        if (bytes != null) {
            HashSet<String> ckeys = new HashSet<String>();
            Map<String, Set<String>> mSysCodes = dataMapper.read(bytes, TypeRef.SYSCODE_MAP);
            ArrayList<String> rSysCodes = sysCodes != null && !sysCodes.isEmpty() ? new ArrayList<String>(sysCodes) : new ArrayList<String>(mSysCodes.keySet());
            while (!rSysCodes.isEmpty()) {
                String rSysCode = (String)rSysCodes.remove(0);
                ckeys.add(Key.map(prefix, rSysCode));
                Set<String> rParamCodes = mSysCodes.remove(rSysCode);
                if (rParamCodes == null) continue;
                for (String rParamCode : rParamCodes) {
                    ckeys.add(Key.value(prefix, rSysCode, rParamCode));
                }
            }
            if (!mSysCodes.isEmpty()) {
                byte[] mbytes = dataMapper.writeAsBytes(mSysCodes, 1);
                operations.set((Object)Key.syscodes(prefix), (Object)mbytes);
            } else {
                ckeys.add(Key.syscodes(prefix));
            }
            redisTemplate.delete(ckeys);
        }
    }

    protected static void remove(DataMapper dataMapper, RedisTemplate<String, byte[]> redisTemplate, String prefix, String sysCode, String paramCode) {
        ValueOperations operations = redisTemplate.opsForValue();
        List lbytes = operations.multiGet(Arrays.asList(Key.syscodes(prefix), Key.map(prefix, sysCode)));
        if (lbytes != null && lbytes.size() == 2) {
            Map<String, Set<String>> sysCodes = lbytes.get(0) != null ? dataMapper.read((byte[])lbytes.get(0), TypeRef.SYSCODE_MAP) : null;
            Map<String, SysParamDto> sysMap = lbytes.get(1) != null ? dataMapper.read((byte[])lbytes.get(1), TypeRef.SYSPARAM_MAP) : null;
            HashMap<String, byte[]> mbytes = new HashMap<String, byte[]>();
            if (sysCodes != null) {
                Set<String> paramCodes = sysCodes.get(sysCode);
                if (paramCodes != null) {
                    paramCodes.remove(paramCode);
                }
                mbytes.put(Key.syscodes(prefix), dataMapper.writeAsBytes(sysCodes, 1));
            }
            if (sysMap != null) {
                sysMap.remove(paramCode);
                mbytes.put(Key.map(prefix, sysCode), dataMapper.writeAsBytes(sysMap, 1));
            }
            operations.multiSet(mbytes);
            redisTemplate.delete((Object)Key.value(prefix, sysCode, paramCode));
        }
    }

    protected static List<SysParamDto> reload(DataMapper dataMapper, RedisTemplate<String, byte[]> redisTemplate, SysParamReloader reloader, String prefix, Collection<String> sysCodes) {
        SysParamHelper.remove(dataMapper, redisTemplate, prefix, sysCodes);
        List sysParams = reloader.reload(sysCodes);
        if (sysParams != null) {
            HashMap<String, byte[]> values = new HashMap<String, byte[]>();
            ValueOperations operations = redisTemplate.opsForValue();
            byte[] bytes = (byte[])operations.get((Object)Key.syscodes(prefix));
            HashMap<String, HashSet<String>> mSysCodes = bytes != null ? dataMapper.read(bytes, TypeRef.SYSCODE_MAP) : new HashMap<String, HashSet<String>>();
            LinkedHashMap<String, LinkedHashMap<String, SysParamDto>> iSysMap = new LinkedHashMap<String, LinkedHashMap<String, SysParamDto>>();
            for (SysParamDto sysParamDto : sysParams) {
                String iSesKey = Key.map(prefix, sysParamDto.getSysCode());
                LinkedHashMap<String, SysParamDto> iParamMap = (LinkedHashMap<String, SysParamDto>)iSysMap.get(iSesKey);
                if (iParamMap == null) {
                    iParamMap = new LinkedHashMap<String, SysParamDto>();
                    iSysMap.put(iSesKey, iParamMap);
                }
                iParamMap.put(sysParamDto.getParamCode(), sysParamDto);
                HashSet<String> mParamCodes = (HashSet<String>)mSysCodes.get(sysParamDto.getSysCode());
                if (mParamCodes == null) {
                    mParamCodes = new HashSet<String>();
                    mSysCodes.put(sysParamDto.getSysCode(), mParamCodes);
                }
                mParamCodes.add(sysParamDto.getParamCode());
                byte[] value = dataMapper.writeAsBytes(sysParamDto, 1);
                values.put(Key.value(prefix, sysParamDto.getSysCode(), sysParamDto.getParamCode()), value);
            }
            for (Map.Entry entry : iSysMap.entrySet()) {
                byte[] value = dataMapper.writeAsBytes(entry.getValue(), 1);
                values.put((String)entry.getKey(), value);
            }
            byte[] value = dataMapper.writeAsBytes(mSysCodes, 1);
            values.put(Key.syscodes(prefix), value);
            operations.multiSet(values);
            mSysCodes.clear();
            iSysMap.clear();
            values.clear();
        }
        return sysParams;
    }

    protected static Map<String, Map<String, SysParamDto>> getSysParamMaps(DataMapper dataMapper, RedisTemplate<String, byte[]> redisTemplate, String prefix, Collection<String> sysCodes) {
        HashMap<String, Map<String, SysParamDto>> maps = new HashMap<String, Map<String, SysParamDto>>();
        if (sysCodes != null) {
            ArrayList<String> lcodes = new ArrayList<String>();
            ArrayList<String> lkeys = new ArrayList<String>();
            for (String sysCode : sysCodes) {
                lcodes.add(sysCode);
                lkeys.add(Key.map(prefix, sysCode));
            }
            ValueOperations valueops = redisTemplate.opsForValue();
            List lvalues = valueops.multiGet(lkeys);
            if (lvalues != null && lvalues.size() == lkeys.size()) {
                int i = 0;
                while (!lvalues.isEmpty()) {
                    byte[] lvalue = (byte[])lvalues.remove(0);
                    Map<Object, Object> mvalue = lvalue != null ? dataMapper.read(lvalue, TypeRef.SYSPARAM_MAP) : new HashMap();
                    maps.put((String)lcodes.get(i), mvalue);
                    ++i;
                }
            }
            lcodes.clear();
            lkeys.clear();
        }
        return maps;
    }

    protected static final class Key {
        private Key() {
        }

        protected static String lock(String prefix) {
            return prefix + "-SysParam-Lock";
        }

        protected static String syscodes(String prefix) {
            return prefix + "-SysParam-SysCodes";
        }

        protected static String map(String prefix, String sysCode) {
            return prefix + "-SysParam-Map-" + sysCode;
        }

        protected static String value(String prefix, String sysCode, String paramCode) {
            return prefix + "-SysParam-Val-" + sysCode + "::" + paramCode;
        }
    }

    protected static final class TypeRef {
        protected static final TypeReference<Map<String, SysParamDto>> SYSPARAM_MAP = new TypeReference<Map<String, SysParamDto>>(){};
        protected static final TypeReference<Map<String, Set<String>>> SYSCODE_MAP = new TypeReference<Map<String, Set<String>>>(){};

        protected TypeRef() {
        }
    }
}

