/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.sysparam;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.ideahut.springboot.bean.BeanConfigure;
import net.ideahut.springboot.bean.BeanReload;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.sysparam.SysParamDto;
import net.ideahut.springboot.sysparam.SysParamHandler;
import net.ideahut.springboot.sysparam.SysParamHelper;
import net.ideahut.springboot.sysparam.SysParamReloader;
import net.ideahut.springboot.sysparam.SysParamRemover;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

public class SysParamHandlerImpl
implements SysParamHandler,
SysParamRemover,
SysParamReloader,
InitializingBean,
BeanReload,
BeanConfigure<SysParamHandler> {
    private boolean reconfigured = false;
    private String prefix;
    private DataMapper dataMapper;
    private RedisTemplate<String, byte[]> redisTemplate;
    private SysParamReloader reloader;

    public SysParamHandlerImpl setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public SysParamHandlerImpl setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return this;
    }

    public SysParamHandlerImpl setRedisTemplate(RedisTemplate<String, byte[]> redisTemplate) {
        this.redisTemplate = redisTemplate;
        return this;
    }

    public SysParamHandlerImpl setReloader(SysParamReloader reloader) {
        this.reloader = reloader;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.redisTemplate, (String)"redisTemplate is required");
        Assert.notNull((Object)this.reloader, (String)"reloader is required");
        if (this.dataMapper == null) {
            this.dataMapper = new DataMapperImpl();
        }
        if (this.prefix == null) {
            this.prefix = "";
        }
    }

    @Override
    public Callable<SysParamHandler> configureBean(ApplicationContext applicationContext) {
        final SysParamHandlerImpl self = this;
        return new Callable<SysParamHandler>(){

            @Override
            public SysParamHandler call() throws Exception {
                SysParamHandlerImpl.this.reloadBean();
                SysParamHandlerImpl.this.reconfigured = true;
                return self;
            }
        };
    }

    @Override
    public boolean isBeanConfigured() {
        return this.reconfigured;
    }

    public boolean reloadBean() throws Exception {
        if (!SysParamHelper.lock(this.redisTemplate, this.prefix, true)) {
            return false;
        }
        try {
            SysParamHelper.clear(this.dataMapper, this.redisTemplate, this.prefix);
            this.reload(null);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            SysParamHelper.lock(this.redisTemplate, this.prefix, false);
        }
        return true;
    }

    public void remove(Collection<String> sysCodes) {
        SysParamHelper.remove(this.dataMapper, this.redisTemplate, this.prefix, sysCodes);
    }

    public void remove(String sysCode, String paramCode) {
        SysParamHelper.remove(this.dataMapper, this.redisTemplate, this.prefix, sysCode, paramCode);
    }

    public List<SysParamDto> reload(Collection<String> sysCodes) {
        return SysParamHelper.reload(this.dataMapper, this.redisTemplate, this.reloader, this.prefix, sysCodes);
    }

    public SysParamDto getSysParam(String sysCode, String paramCode) {
        String key = SysParamHelper.Key.value(this.prefix, sysCode, paramCode);
        byte[] value = (byte[])this.redisTemplate.opsForValue().get((Object)key);
        return value != null ? this.dataMapper.read(value, SysParamDto.class) : null;
    }

    public Map<String, SysParamDto> getSysParamMap(String sysCode) {
        String key = SysParamHelper.Key.map(this.prefix, sysCode);
        byte[] value = (byte[])this.redisTemplate.opsForValue().get((Object)key);
        return value != null ? this.dataMapper.read(value, SysParamHelper.TypeRef.SYSPARAM_MAP) : new HashMap<String, SysParamDto>();
    }

    public Map<String, Map<String, SysParamDto>> getSysParamMaps(Collection<String> sysCodes) {
        return SysParamHelper.getSysParamMaps(this.dataMapper, this.redisTemplate, this.prefix, sysCodes);
    }

    public <T> T getValue(Class<T> type, String sysCode, String paramCode, T defaultValue) {
        SysParamDto sysParam = this.getSysParam(sysCode, paramCode);
        return (T)(sysParam != null ? sysParam.getValue(type, defaultValue) : defaultValue);
    }

    public <T> T getValue(Class<T> type, String sysCode, String paramCode) {
        return this.getValue(type, sysCode, paramCode, null);
    }

    public <T> T getValue(Class<T> type, Map<String, SysParamDto> sysMap, String paramCode, T defaultValue) {
        SysParamDto sysParam = sysMap.get(paramCode);
        return (T)(sysParam != null ? sysParam.getValue(type, defaultValue) : defaultValue);
    }

    public <T> T getValue(Class<T> type, Map<String, SysParamDto> sysMap, String paramCode) {
        return this.getValue(type, sysMap, paramCode, null);
    }

    public byte[] getBytes(String sysCode, String paramCode, byte[] defaultValue) {
        SysParamDto sysParam = this.getSysParam(sysCode, paramCode);
        byte[] bytes = sysParam != null ? sysParam.getBytes() : null;
        return bytes != null ? bytes : defaultValue;
    }

    public byte[] getBytes(String sysCode, String paramCode) {
        return this.getBytes(sysCode, paramCode, null);
    }
}

