/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.security;

import java.util.Base64;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.security.ReactiveSecurityAuthorization;
import net.ideahut.springboot.security.SecurityCredential;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ReactiveBasicAuthSecurity
implements ReactiveSecurityAuthorization,
InitializingBean {
    private String realm;
    private SecurityCredential credential;

    public ReactiveBasicAuthSecurity setRealm(String realm) {
        this.realm = realm;
        return this;
    }

    public ReactiveBasicAuthSecurity setCredential(SecurityCredential credential) {
        this.credential = credential;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.credential, (String)"credential is required");
        if (this.realm == null) {
            this.realm = "Protected";
        }
    }

    @Override
    public Mono<Void> isRequestAuthorized(ServerWebExchange exchange) {
        String basic;
        int idx;
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        boolean authorized = false;
        String authorization = request.getHeaders().getFirst("Authorization");
        if (authorization != null && (idx = authorization.indexOf(" ")) != -1 && "Basic".equalsIgnoreCase(basic = authorization.substring(0, idx))) {
            String userpass = new String(Base64.getDecoder().decode(authorization.substring(idx + 1)));
            idx = userpass.indexOf(":");
            if (idx == -1) {
                return Mono.empty();
            }
            String username = userpass.substring(0, idx);
            String password = userpass.substring(idx + 1);
            MapStringObject parameter = new MapStringObject().setValue("authorization", (Object)authorization).setValue("username", (Object)username).setValue("password", (Object)password);
            authorized = this.credential.isValidCredential(parameter);
        }
        if (!authorized) {
            response.getHeaders().set("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
            response.setStatusCode((HttpStatusCode)HttpStatus.UNAUTHORIZED);
            return Mono.empty();
        }
        return null;
    }
}

