/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.redis;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.ideahut.springboot.redis.RedisProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

public final class RedisHelper {
    private RedisHelper() {
    }

    public static RedisConnectionFactory createRedisConnectionFactory(RedisProperties properties, boolean initialize) throws Exception {
        RedisConnectionFactory connectionFactory = properties.createConnectionFactory();
        if (initialize && connectionFactory instanceof InitializingBean) {
            ((InitializingBean)connectionFactory).afterPropertiesSet();
        }
        if (Boolean.TRUE.equals(properties.getTestOnStartup())) {
            connectionFactory.getConnection().ping();
        }
        return connectionFactory;
    }

    public static <K, V> RedisTemplate<K, V> createRedisTemplate(RedisConnectionFactory connectionFactory, boolean initialize) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(connectionFactory);
        if (initialize) {
            template.afterPropertiesSet();
        }
        return template;
    }

    public static <K, V> RedisTemplate<K, V> createRedisTemplate(RedisProperties properties, boolean initialize) throws Exception {
        RedisConnectionFactory connectionFactory = RedisHelper.createRedisConnectionFactory(properties, initialize);
        return RedisHelper.createRedisTemplate(connectionFactory, initialize);
    }

    public static <K, V> V getValue(RedisTemplate<K, V> template, String prefix, K key) {
        if (key != null) {
            ValueOperations operation = template.opsForValue();
            if (key instanceof String && prefix != null) {
                String ckey = prefix + key;
                return (V)operation.get((Object)ckey);
            }
            return (V)operation.get(key);
        }
        return null;
    }

    public static <K, V> V getValue(RedisTemplate<K, V> template, K key) {
        return RedisHelper.getValue(template, null, key);
    }

    public static <K, V> void setValue(RedisTemplate<K, V> template, String prefix, K key, V value, long timeout, TimeUnit timeunit) {
        if (key != null && value != null) {
            ValueOperations operation = template.opsForValue();
            if (key instanceof String && prefix != null) {
                String ckey = prefix + key;
                if (timeout > 0L) {
                    operation.set((Object)ckey, value, timeout, timeunit);
                } else {
                    operation.set((Object)ckey, value);
                }
            } else if (timeout > 0L) {
                operation.set(key, value, timeout, timeunit);
            } else {
                operation.set(key, value);
            }
        }
    }

    public static <K, V> void setValue(RedisTemplate<K, V> template, K key, V value, long timeout, TimeUnit timeunit) {
        RedisHelper.setValue(template, null, key, value, timeout, timeunit);
    }

    public static <K, V> void setValue(RedisTemplate<K, V> template, String prefix, K key, V value) {
        RedisHelper.setValue(template, prefix, key, value, 0L, null);
    }

    public static <K, V> void setValue(RedisTemplate<K, V> template, K key, V value) {
        RedisHelper.setValue(template, null, key, value, 0L, null);
    }

    public static <K, V> List<V> getValues(RedisTemplate<K, V> template, String prefix, Collection<K> keys) {
        if (keys != null && !keys.isEmpty()) {
            ValueOperations operation = template.opsForValue();
            if (keys.iterator().next() instanceof String && prefix != null) {
                ArrayList<CallSite> ckeys = new ArrayList<CallSite>();
                for (K key : keys) {
                    String ckey = prefix + key;
                    ckeys.add((CallSite)((Object)ckey));
                }
                return operation.multiGet(ckeys);
            }
            return operation.multiGet(keys);
        }
        return new ArrayList();
    }

    public static <K, V> List<V> getValues(RedisTemplate<K, V> template, Collection<K> keys) {
        return RedisHelper.getValues(template, null, keys);
    }

    public static <K, V> void deleteKey(RedisTemplate<K, V> template, String prefix, K key) {
        if (key != null) {
            if (key instanceof String && prefix != null) {
                String ckey = prefix + key;
                template.delete((Object)ckey);
            } else {
                template.delete(key);
            }
        }
    }

    public static <K, V> void deleteKey(RedisTemplate<K, V> template, K key) {
        RedisHelper.deleteKey(template, null, key);
    }

    public static <K, V> void deleteKeys(RedisTemplate<K, V> template, String prefix, Collection<K> keys) {
        if (keys != null && !keys.isEmpty()) {
            if (keys.iterator().next() instanceof String && prefix != null) {
                ArrayList<CallSite> ckeys = new ArrayList<CallSite>();
                for (K key : keys) {
                    String ckey = prefix + key;
                    ckeys.add((CallSite)((Object)ckey));
                }
                template.delete(ckeys);
            } else {
                template.delete(keys);
            }
        }
    }

    public static <K, V> void deleteKeys(RedisTemplate<K, V> template, Collection<K> keys) {
        RedisHelper.deleteKeys(template, null, keys);
    }
}

