/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.job;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import net.ideahut.springboot.job.JobGroupDto;
import net.ideahut.springboot.job.JobService;
import net.ideahut.springboot.job.JobTriggerDto;
import net.ideahut.springboot.job.JobTypeDto;
import net.ideahut.springboot.task.TaskListExecutor;
import net.ideahut.springboot.util.FrameworkUtil;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

final class SchedulerHelper {
    private static final Logger log = LoggerFactory.getLogger(SchedulerHelper.class);

    private SchedulerHelper() {
    }

    private static <T extends Job> Class<T> getJobClass(String classname) {
        try {
            return Class.forName(classname);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static <T extends Job> Class<T> getJobClass(Set<String> jobPackages, String classname) {
        Class<T> jobClass;
        block1: {
            String jobPackage;
            jobClass = SchedulerHelper.getJobClass(classname);
            if (jobClass != null || jobPackages == null) break block1;
            Iterator<String> iterator = jobPackages.iterator();
            while (iterator.hasNext() && (jobClass = SchedulerHelper.getJobClass((jobPackage = iterator.next()) + "." + classname)) == null) {
            }
        }
        return jobClass;
    }

    protected static void start(final Scheduler scheduler, JobService jobService, Set<String> jobPackages, String instanceId, ApplicationContext applicationContext) throws SchedulerException {
        List groups = jobService.getGroupsAndTriggers(instanceId, Boolean.TRUE, null, Boolean.valueOf(true));
        ArrayList<SchedulerJob> candidates = new ArrayList<SchedulerJob>();
        ArrayList<JobDetail> startups = new ArrayList<JobDetail>();
        while (!groups.isEmpty()) {
            JobGroupDto group = (JobGroupDto)groups.remove(0);
            for (JobTriggerDto trigger : group.getTriggers()) {
                SchedulerJob schedulerJob = SchedulerHelper.createSchedulerJob(group, trigger, jobPackages, applicationContext, jobService);
                candidates.add(schedulerJob);
                if (!FrameworkUtil.isTrue(trigger.getIsRunOnStartup())) continue;
                startups.add(schedulerJob.getJobDetail());
            }
        }
        scheduler.clear();
        while (!candidates.isEmpty()) {
            SchedulerJob scJob = (SchedulerJob)candidates.remove(0);
            scheduler.deleteJob(scJob.getJobDetail().getKey());
            scheduler.scheduleJob(scJob.getJobDetail(), scJob.getJobTrigger());
        }
        scheduler.start();
        if (!startups.isEmpty()) {
            TaskListExecutor executor = TaskListExecutor.of((Integer)(startups.size() > 3 ? 3 : startups.size()));
            while (!startups.isEmpty()) {
                final JobDetail jobDetail = (JobDetail)startups.remove(0);
                executor.add((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        scheduler.triggerJob(jobDetail.getKey(), jobDetail.getJobDataMap());
                        return null;
                    }
                });
            }
            try {
                executor.concurrent(null);
            }
            catch (Exception e) {
                log.error("Scheduler-Startups", (Throwable)e);
            }
        }
    }

    protected static SchedulerJob createSchedulerJob(JobGroupDto group, JobTriggerDto trigger, Set<String> jobPackages, ApplicationContext applicationContext, JobService jobService) throws SchedulerException {
        String cronExpression = trigger.getCronExpression();
        if (!CronExpression.isValidExpression((String)cronExpression)) {
            throw new SchedulerException("Invalid cron expression: " + cronExpression);
        }
        JobTypeDto type = trigger.getType();
        Class jobClass = SchedulerHelper.getJobClass(jobPackages, type.getClassname());
        CronScheduleBuilder schedule = CronScheduleBuilder.cronSchedule((String)cronExpression);
        ZoneOffset zoneOffset = null;
        if (trigger.getZoneOffsetSeconds() != null) {
            zoneOffset = ZoneOffset.ofTotalSeconds(trigger.getZoneOffsetSeconds());
        } else if (group.getZoneOffsetSeconds() != null) {
            zoneOffset = ZoneOffset.ofTotalSeconds(group.getZoneOffsetSeconds());
        }
        TimeZone timeZone = zoneOffset != null ? TimeZone.getTimeZone(zoneOffset) : TimeZone.getDefault();
        schedule.inTimeZone(timeZone);
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(trigger.getTriggerId(), group.getGroupId()).withSchedule((ScheduleBuilder)schedule);
        CronTrigger cronTrigger = (CronTrigger)triggerBuilder.build();
        JobBuilder jobBuilder = JobBuilder.newJob(jobClass).withIdentity(trigger.getTriggerId(), group.getGroupId());
        JobDetail jobDetail = jobBuilder.build();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        jobDataMap.put("$TRIGGER", (Object)trigger);
        jobDataMap.put("$CONTEXT", (Object)applicationContext);
        jobDataMap.put("$SERVICE", (Object)jobService);
        return new SchedulerJob(jobDetail, (Trigger)cronTrigger);
    }

    protected static void checkScheduler(Scheduler scheduler) throws SchedulerException {
        if (scheduler == null || !scheduler.isStarted()) {
            throw new SchedulerException("Scheduler is not available");
        }
    }

    protected static JobTriggerDto getTriggerDto(Scheduler scheduler, JobService jobService, String triggerId) throws SchedulerException {
        SchedulerHelper.checkScheduler(scheduler);
        JobTriggerDto triggerDto = jobService.getTrigger(triggerId, Boolean.valueOf(false));
        Assert.notNull((Object)triggerDto, (String)"TriggerDto is not found");
        triggerDto.setStatus(new JobTriggerDto.Status());
        return triggerDto;
    }

    protected static TriggerKey getTriggerKey(Scheduler scheduler, JobTriggerDto triggerDto) throws SchedulerException {
        TriggerKey triggerKey = new TriggerKey(triggerDto.getTriggerId(), triggerDto.getGroup().getGroupId());
        Assert.isTrue((boolean)scheduler.checkExists(triggerKey), (String)"TriggerKey is not available");
        return triggerKey;
    }

    protected static void updateStatus(JobTriggerDto.Status status, Scheduler scheduler, TriggerKey key) throws SchedulerException {
        if (scheduler != null) {
            status.setScheduled(Boolean.valueOf(scheduler.checkExists(key)));
            if (Boolean.TRUE.equals(status.getScheduled())) {
                Trigger.TriggerState state = scheduler.getTriggerState(key);
                status.setState(state != null ? state.name() : null);
                Trigger trigger = scheduler.getTrigger(key);
                status.setEndTime(trigger.getEndTime() != null ? Long.valueOf(trigger.getEndTime().getTime()) : null);
                status.setFinalFireTime(trigger.getFinalFireTime() != null ? Long.valueOf(trigger.getFinalFireTime().getTime()) : null);
                status.setMayFireAgain(Boolean.valueOf(trigger.mayFireAgain()));
                status.setNextFireTime(trigger.getNextFireTime() != null ? Long.valueOf(trigger.getNextFireTime().getTime()) : null);
                status.setPreviousFireTime(trigger.getPreviousFireTime() != null ? Long.valueOf(trigger.getPreviousFireTime().getTime()) : null);
                status.setPriority(Integer.valueOf(trigger.getPriority()));
                status.setStartTime(trigger.getStartTime() != null ? Long.valueOf(trigger.getStartTime().getTime()) : null);
            }
        }
    }

    protected static class SchedulerJob {
        private final JobDetail jobDetail;
        private final Trigger jobTrigger;

        protected SchedulerJob(JobDetail jobDetail, Trigger jobTrigger) {
            this.jobDetail = jobDetail;
            this.jobTrigger = jobTrigger;
        }

        public JobDetail getJobDetail() {
            return this.jobDetail;
        }

        public Trigger getJobTrigger() {
            return this.jobTrigger;
        }
    }

    protected static final class TypeRef {
        protected static final TypeReference<List<String>> STRING_LIST = new TypeReference<List<String>>(){};

        protected TypeRef() {
        }
    }
}

