/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.job;

import java.time.Instant;
import net.ideahut.springboot.job.JobService;
import net.ideahut.springboot.job.JobTriggerDto;
import net.ideahut.springboot.job.JobTypeDto;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.util.FrameworkUtil;
import org.apache.commons.lang3.RandomStringUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.ApplicationContext;

public abstract class JobBase
implements Job {
    private static final DataMapper mapper = new DataMapperImpl();
    private static final Logger logger = LoggerFactory.getLogger(JobBase.class);
    public static final String TRIGGER = "$TRIGGER";
    public static final String CONTEXT = "$CONTEXT";
    public static final String SERVICE = "$SERVICE";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        boolean isContinue = this.isContinue(context);
        if (!isContinue) {
            return;
        }
        JobService service = this.getService(context);
        JobTriggerDto ctxJobTrigger = this.getTrigger(context);
        String traceId = ctxJobTrigger.getTriggerId() + "::" + RandomStringUtils.randomAlphanumeric((int)6);
        MDC.put((String)service.getTraceKey(), (String)traceId);
        try {
            this.run(context);
        }
        catch (Exception e) {
            throw new JobExecutionException((Throwable)e);
        }
        finally {
            this.save(context);
        }
    }

    private boolean isContinue(JobExecutionContext context) {
        JobTriggerDto ctxTrigger = this.getTrigger(context);
        if (ctxTrigger == null) {
            return false;
        }
        JobTypeDto ctxType = ctxTrigger.getType();
        if (ctxType == null) {
            return false;
        }
        if (!FrameworkUtil.isTrue(ctxType.getIsSingleRun())) {
            return true;
        }
        JobService service = this.getService(context);
        JobTriggerDto trigger = service.getTrigger(ctxTrigger.getTriggerId(), Boolean.valueOf(true));
        if (trigger != null) {
            JobTypeDto type = trigger.getType();
            if (FrameworkUtil.isTrue(type.getIsSingleRun())) {
                if (FrameworkUtil.isTrue(type.getIsRunning())) {
                    return false;
                }
                service.setTypeIsRunning(type.getTypeId(), Boolean.TRUE);
            }
            ctxType.setIsSaveResult(type.getIsSaveResult());
            ctxType.setLastRunData(type.getLastRunData());
            ctxType.setLastRunTime(type.getLastRunTime());
            ctxType.setLastRunTriggerId(type.getLastRunTriggerId());
            ctxTrigger.setIsSaveResult(trigger.getIsSaveResult());
            ctxTrigger.setLastRunData(trigger.getLastRunData());
            ctxTrigger.setLastRunTime(trigger.getLastRunTime());
            this.updateJobTriggerContext(context, ctxTrigger);
        }
        return true;
    }

    private void save(JobExecutionContext context) {
        JobTypeDto ctxType;
        JobTriggerDto ctxTrigger = this.getTrigger(context);
        if (ctxTrigger == null) {
            return;
        }
        JobService service = this.getService(context);
        String lastRunTriggerId = ctxTrigger.getTriggerId();
        Long lastRunTime = Instant.now().toEpochMilli();
        String lastRunData = null;
        Object ctxResult = context.getResult();
        if (ctxResult != null) {
            lastRunData = ctxResult instanceof String ? (String)ctxResult : mapper.writeAsString(ctxResult, 1);
        }
        if (FrameworkUtil.isTrue(ctxTrigger.getIsSaveResult())) {
            service.saveTriggerResult(lastRunTriggerId, lastRunTime, lastRunData);
            ctxTrigger.setLastRunTime(lastRunTime);
            ctxTrigger.setLastRunData(lastRunData);
        }
        if ((ctxType = ctxTrigger.getType()) != null) {
            if (FrameworkUtil.isTrue(ctxType.getIsSaveResult())) {
                service.saveTypeResult(ctxType.getTypeId(), Boolean.FALSE, lastRunTime, lastRunTriggerId, lastRunData);
            } else if (FrameworkUtil.isTrue(ctxType.getIsSingleRun())) {
                service.setTypeIsRunning(ctxType.getTypeId(), Boolean.FALSE);
            }
            ctxType.setLastRunData(lastRunData);
            ctxType.setLastRunTime(lastRunTime);
            ctxType.setLastRunTriggerId(lastRunTriggerId);
        }
        this.updateJobTriggerContext(context, ctxTrigger);
    }

    private void updateJobTriggerContext(JobExecutionContext context, JobTriggerDto trigger) {
        context.getJobDetail().getJobDataMap().put(TRIGGER, (Object)trigger);
    }

    private JobService getService(JobExecutionContext context) {
        return (JobService)context.getJobDetail().getJobDataMap().get((Object)SERVICE);
    }

    protected DataMapper mapper() {
        return mapper;
    }

    protected Logger logger() {
        return logger;
    }

    protected ApplicationContext getApplicationContext(JobExecutionContext context) {
        return (ApplicationContext)context.getJobDetail().getJobDataMap().get((Object)CONTEXT);
    }

    protected JobTriggerDto getTrigger(JobExecutionContext context) {
        return (JobTriggerDto)context.getJobDetail().getJobDataMap().get((Object)TRIGGER);
    }

    protected <T> T getConfigValue(JobExecutionContext context, Class<T> type, String name, T defaultValue) {
        JobTriggerDto.Configuration config;
        JobTriggerDto trigger = this.getTrigger(context);
        if (trigger != null && trigger.getConfigurations() != null && (config = (JobTriggerDto.Configuration)trigger.getConfigurations().get(name)) != null) {
            return (T)config.getConfigValue(type, defaultValue);
        }
        return defaultValue;
    }

    protected <T> T getConfigValue(JobExecutionContext context, Class<T> type, String name) {
        return this.getConfigValue(context, type, name, null);
    }

    protected abstract void run(JobExecutionContext var1) throws Exception;
}

