/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.init;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.init.InitEnum;
import net.ideahut.springboot.init.InitHandler;
import net.ideahut.springboot.init.InitMapper;
import net.ideahut.springboot.init.InitRequest;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.rest.RestClient;
import net.ideahut.springboot.rest.RestMethod;
import net.ideahut.springboot.rest.RestResponse;
import org.apache.commons.httpclient.HttpMethod;
import org.hibernate.engine.jdbc.internal.JdbcCoordinatorImpl;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.sql.spi.NativeQueryImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class InitHandlerImpl
implements InitHandler {
    private static final Logger log = LoggerFactory.getLogger(InitHandlerImpl.class);
    private InitHandler.Endpoint endpoint;

    public InitHandlerImpl setEndpoint(InitHandler.Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @Override
    public void initMapper(ApplicationContext context) throws Exception {
        Map mapInitMapper;
        Map mapObjectMapper = context.getBeansOfType(ObjectMapper.class);
        if (mapObjectMapper != null) {
            for (ObjectMapper mapper : mapObjectMapper.values()) {
                InitMapper.loadDefault(mapper);
            }
        }
        Map mapDataMapper = context.getBeansOfType(DataMapper.class);
        if (mapObjectMapper != null) {
            for (DataMapper mapper : mapDataMapper.values()) {
                InitMapper.loadDefault(mapper);
            }
        }
        if ((mapInitMapper = context.getBeansOfType(InitMapper.class)) != null) {
            for (InitMapper initMapper : mapInitMapper.values()) {
                initMapper.onInitMapper();
            }
        }
    }

    @Override
    public void initClass() {
        JsonNodeType.class.getName();
        EntityNative.class.getName();
        EntityNative.ColumnConverter.class.getName();
        EntityNative.LazyLoad.class.getName();
        EntityNative.Parameter.class.getName();
        EntityNative.Select.class.getName();
        JdbcCoordinatorImpl.class.getName();
        SessionEventListenerManager.class.getName();
        QueryImplementor.class.getName();
        NativeQueryImplementor.class.getName();
        TransactionImplementor.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initServlet() {
        String url = this.endpoint != null ? this.endpoint.getUrl() : null;
        String string = url = url != null ? url.trim() : "";
        if (!url.isEmpty()) {
            log.info("Sending request to force DispatcherServlet initialization...");
            InitRequest request = this.sampleRequest();
            DataMapperImpl mapper = new DataMapperImpl();
            byte[] body = mapper.writeAsBytes(request, 1);
            try (RestClient client = RestClient.of(5000, 10000);){
                HttpMethod method = RestMethod.POST.newHttpMethod(url, body);
                method.setRequestHeader("Content-Type", "application/json");
                RestResponse response = RestResponse.of(client, method);
                String content = response.getBodyAsString();
                method.releaseConnection();
                log.info("...done DispatcherServlet initialization, response status: " + response.getStatus() + ", body: " + content);
            }
        }
    }

    @Override
    public void initValidation() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.sampleRequest(), new Class[0]);
        log.info("Number of violations found: " + violations.size());
    }

    private InitRequest sampleRequest() {
        InitRequest message = new InitRequest();
        message.setInitString("init string");
        message.setInitNumber(15);
        message.setInitBigDecimal(BigDecimal.TEN);
        message.setInitEnum(InitEnum.WARM);
        return message;
    }
}

