/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.grid;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.grid.GridSource;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.util.FrameworkUtil;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

final class GridHelper {
    private GridHelper() {
    }

    protected static void clear(String prefix, DataMapper dataMapper, RedisTemplate<String, byte[]> redisTemplate, Map<String, byte[]> stores) {
        if (redisTemplate != null) {
            String lkey = Keys.keys(prefix);
            ValueOperations valueOps = redisTemplate.opsForValue();
            byte[] bytes = (byte[])valueOps.get((Object)lkey);
            if (bytes != null) {
                Set<String> keys = dataMapper.read(bytes, TypeRef.STRING_SET);
                keys.add(lkey);
                redisTemplate.delete(keys);
            }
        } else {
            stores.clear();
        }
    }

    protected static synchronized boolean lock(String prefix, RedisTemplate<String, byte[]> redisTemplate, Map<String, byte[]> stores, boolean yes) {
        String lockKey = Keys.lock(prefix);
        if (redisTemplate != null) {
            if (yes) {
                ValueOperations lockOps = redisTemplate.opsForValue();
                byte[] lockBytes = (byte[])lockOps.get((Object)lockKey);
                if (lockBytes != null) {
                    return false;
                }
                lockOps.set((Object)lockKey, (Object)"1".getBytes());
            } else {
                redisTemplate.delete((Object)lockKey);
            }
        } else if (yes) {
            byte[] lockBytes = stores.get(lockKey);
            if (lockBytes != null) {
                return false;
            }
            stores.put(lockKey, "1".getBytes());
        } else {
            stores.remove(lockKey);
        }
        return true;
    }

    protected static Map<String, List<GridSource>> load(DataMapper dataMapper, String location) throws Exception {
        LinkedHashMap<String, List<GridSource>> map = new LinkedHashMap<String, List<GridSource>>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(GridHelper.class.getClassLoader());
        Resource[] resources = resolver.getResources(FrameworkUtil.replacePath(location));
        for (Resource resource : resources) {
            String path = resource.getURI().getPath();
            int idx = path.lastIndexOf("/");
            String parent = path.substring(0, idx);
            idx = parent.lastIndexOf("/");
            ArrayList<GridSource> list = (ArrayList<GridSource>)map.get(parent = parent.substring(idx + 1));
            if (list == null) {
                list = new ArrayList<GridSource>();
                map.put(parent, list);
            }
            byte[] bytes = resource.getContentAsByteArray();
            JsonNode data = dataMapper.read(bytes, JsonNode.class, 1);
            String name = data.get("name").asText();
            String title = data.get("title").asText();
            Integer order = data.has("order") ? data.get("order").asInt() : Integer.MAX_VALUE;
            GridSource source = new GridSource();
            source.setData(data);
            source.setName(name);
            source.setOrder(order);
            source.setParent(parent);
            source.setTitle(title);
            list.add(source);
        }
        for (Map.Entry entry : map.entrySet()) {
            Collections.sort((List)entry.getValue(), Sort.TITLE);
            Collections.sort((List)entry.getValue(), Sort.ORDER);
        }
        return map;
    }

    protected static final class Keys {
        protected static final String SEPARATOR = "-#-";
        protected static final String PARENT = "_";

        private Keys() {
        }

        protected static String lock(String prefix) {
            return prefix + "--LOCK--";
        }

        protected static String keys(String prefix) {
            return prefix + "--KEYS--";
        }

        protected static String sources(String prefix) {
            return prefix + "--SOURCES--";
        }
    }

    protected static final class TypeRef {
        protected static final TypeReference<Set<String>> STRING_SET = new TypeReference<Set<String>>(){};
        protected static final TypeReference<Map<String, List<GridSource>>> SOURCE_MAP = new TypeReference<Map<String, List<GridSource>>>(){};

        protected TypeRef() {
        }
    }

    protected static final class Sort {
        protected static final Comparator<GridSource> TITLE = new Comparator<GridSource>(){

            @Override
            public int compare(GridSource o1, GridSource o2) {
                return o1.getTitle().compareTo(o2.getTitle());
            }
        };
        protected static final Comparator<GridSource> ORDER = new Comparator<GridSource>(){

            @Override
            public int compare(GridSource o1, GridSource o2) {
                return o1.getOrder().compareTo(o2.getOrder());
            }
        };

        protected Sort() {
        }
    }

    protected static interface Loader {
        public void onLoaded(GridSource var1) throws Exception;
    }
}

