/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.grid;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.ideahut.springboot.bean.BeanConfigure;
import net.ideahut.springboot.bean.BeanReload;
import net.ideahut.springboot.grid.GridAdditional;
import net.ideahut.springboot.grid.GridHandler;
import net.ideahut.springboot.grid.GridHelper;
import net.ideahut.springboot.grid.GridOption;
import net.ideahut.springboot.grid.GridSource;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.object.Option;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.util.Assert;

public class GridHandlerImpl
implements GridHandler,
InitializingBean,
BeanReload,
BeanConfigure<GridHandler> {
    private boolean reconfigured = false;
    private ApplicationContext applicationContext;
    private DataMapper dataMapper;
    private String prefix;
    private String location;
    private Map<String, GridOption> options = new LinkedHashMap<String, GridOption>();
    private Map<String, GridAdditional> additionals = new LinkedHashMap<String, GridAdditional>();
    private RedisTemplate<String, byte[]> redisTemplate;
    private Map<String, byte[]> stores = new LinkedHashMap<String, byte[]>();

    public GridHandlerImpl setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        return this;
    }

    public GridHandlerImpl setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return this;
    }

    public GridHandlerImpl setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public GridHandlerImpl setLocation(String location) {
        this.location = location;
        return this;
    }

    public GridHandlerImpl setOptions(Map<String, GridOption> options) {
        this.options = options != null ? new LinkedHashMap<String, GridOption>(options) : new LinkedHashMap();
        return this;
    }

    public GridHandlerImpl putOption(String name, GridOption option) {
        if (name != null && option != null) {
            this.options.put(name, option);
        }
        return this;
    }

    public GridHandlerImpl setAdditionals(Map<String, GridAdditional> additionals) {
        this.additionals = additionals != null ? new LinkedHashMap<String, GridAdditional>(additionals) : new LinkedHashMap();
        return this;
    }

    public GridHandlerImpl putAdditional(String name, GridAdditional additional) {
        if (name != null && additional != null) {
            this.additionals.put(name, additional);
        }
        return this;
    }

    public GridHandlerImpl setRedisTemplate(RedisTemplate<String, byte[]> redisTemplate) {
        this.redisTemplate = redisTemplate;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.applicationContext, (String)"applicationContext is required");
        Assert.hasLength((String)this.location, (String)"location is required");
        if (this.dataMapper == null) {
            this.dataMapper = new DataMapperImpl();
        }
        if (this.prefix == null) {
            this.prefix = GridHandler.class.getSimpleName();
        }
    }

    @Override
    public Callable<GridHandler> configureBean(ApplicationContext applicationContext) {
        final GridHandlerImpl self = this;
        return new Callable<GridHandler>(){

            @Override
            public GridHandler call() throws Exception {
                GridHandlerImpl.this.reloadBean();
                GridHandlerImpl.this.reconfigured = true;
                return self;
            }
        };
    }

    @Override
    public boolean isBeanConfigured() {
        return this.reconfigured;
    }

    public boolean reloadBean() throws Exception {
        if (!GridHelper.lock(this.prefix, this.redisTemplate, this.stores, true)) {
            return false;
        }
        GridHelper.clear(this.prefix, this.dataMapper, this.redisTemplate, this.stores);
        try {
            String key;
            Map<String, List<GridSource>> map = GridHelper.load(this.dataMapper, this.location);
            if (map.size() == 1 && !"_".equals(key = map.keySet().iterator().next())) {
                map.put("_", map.get(key));
                map.remove(key);
            }
            Map<String, List<GridSource>> sources = this.dataMapper.copy(map, GridHelper.TypeRef.SOURCE_MAP);
            LinkedHashMap<Object, byte[]> caches = new LinkedHashMap<Object, byte[]>();
            for (Map.Entry<String, List<GridSource>> entry : map.entrySet()) {
                String parent = entry.getKey();
                for (int i = 0; i < entry.getValue().size(); ++i) {
                    GridSource source = entry.getValue().get(i);
                    String ckey = this.prefix + "-#-" + parent + "-#-" + source.getName();
                    if (caches.containsKey(ckey)) {
                        throw new Exception("Duplicate grid key: " + ckey);
                    }
                    caches.put(ckey, this.dataMapper.writeAsBytes(source.getData(), 1));
                    sources.get(parent).get(i).setData(null);
                }
            }
            byte[] sbytes = this.dataMapper.writeAsBytes(sources, 1);
            caches.put(GridHelper.Keys.sources(this.prefix), sbytes);
            byte[] kbytes = this.dataMapper.writeAsBytes(caches.keySet(), 1);
            caches.put(GridHelper.Keys.keys(this.prefix), kbytes);
            if (this.redisTemplate != null) {
                this.redisTemplate.opsForValue().multiSet(caches);
            } else {
                this.stores = new HashMap<String, byte[]>(caches);
            }
        }
        catch (Exception e) {
            GridHelper.clear(this.prefix, this.dataMapper, this.redisTemplate, this.stores);
            throw e;
        }
        finally {
            GridHelper.lock(this.prefix, this.redisTemplate, this.stores, false);
        }
        return true;
    }

    @Override
    public ObjectNode getGrid(String parent, String name) {
        String key;
        ArrayNode jarrays;
        ObjectNode nodes;
        String cpar;
        BeanConfigure.checkBeanConfigure(this);
        String string = cpar = parent != null ? parent.trim() : "";
        if (cpar.isEmpty()) {
            cpar = "_";
        }
        String ckey = this.prefix + "-#-" + cpar + "-#-" + name;
        byte[] bytes = null;
        ValueOperations valueOps = this.redisTemplate != null ? this.redisTemplate.opsForValue() : null;
        bytes = valueOps != null ? (byte[])valueOps.get((Object)ckey) : this.stores.get(ckey);
        if (bytes == null) {
            return null;
        }
        ObjectNode jgrid = this.dataMapper.read(bytes, ObjectNode.class);
        if (jgrid.has("options")) {
            JsonNode joptions = jgrid.get("options");
            if (joptions.isArray()) {
                nodes = this.dataMapper.createObjectNode();
                jarrays = (ArrayNode)joptions;
                for (JsonNode joption : jarrays) {
                    key = joption.asText();
                    GridOption gridOption = this.options.get(key);
                    if (gridOption == null) continue;
                    List<Option> option = gridOption.getOption(this.applicationContext);
                    nodes.putArray(key).addAll(this.dataMapper.convert(option, ArrayNode.class));
                }
                jgrid.set("options", (JsonNode)nodes);
            } else {
                jgrid.remove("options");
            }
        }
        if (jgrid.has("additionals")) {
            JsonNode jadditionals = jgrid.get("additionals");
            if (jadditionals.isArray()) {
                nodes = this.dataMapper.createObjectNode();
                jarrays = (ArrayNode)jadditionals;
                for (JsonNode jadditional : jarrays) {
                    key = jadditional.asText();
                    GridAdditional gridAdditional = this.additionals.get(key);
                    if (gridAdditional == null) continue;
                    ArrayNode node = gridAdditional.getAdditional(this.applicationContext);
                    nodes.set(key, (JsonNode)node);
                }
                jgrid.set("additionals", (JsonNode)nodes);
            } else {
                jgrid.remove("additionals");
            }
        }
        return jgrid;
    }

    @Override
    public Map<String, List<GridSource>> getSources() {
        BeanConfigure.checkBeanConfigure(this);
        String skey = GridHelper.Keys.sources(this.prefix);
        byte[] bytes = null;
        bytes = this.redisTemplate != null ? (byte[])this.redisTemplate.opsForValue().get((Object)skey) : this.stores.get(skey);
        return bytes != null ? this.dataMapper.read(bytes, GridHelper.TypeRef.SOURCE_MAP) : null;
    }
}

