/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.generator;

import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import net.ideahut.springboot.annotation.IdPrefix;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.spi.StandardGenerator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;

public class OdtIdGenerator
implements IdentifierGenerator,
StandardGenerator {
    private static final int LENGTH = 4;
    private static final int TEN = 10;
    public static final String NAME = "OdtIdGenerator";
    public static final String STRATEGY = "net.ideahut.springboot.generator.OdtIdGenerator";
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-QMMdde-HHmm-ssSSS");
    private static AtomicLong atomicLong = new AtomicLong();
    private static int tailLength = 4;
    private static int tailNumber = (int)Math.pow(10.0, tailLength);
    private String entityName;

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        this.entityName = params.getProperty("entity_name");
    }

    public Serializable generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        Object id = (Serializable)session.getEntityPersister(this.entityName, object).getIdentifier(object, session);
        if (id == null || "null".equals(id)) {
            IdPrefix idPrefix = object.getClass().getAnnotation(IdPrefix.class);
            String prefix = idPrefix != null ? idPrefix.value().trim() : "";
            id = OdtIdGenerator.createId(prefix);
        }
        return id;
    }

    public static void setTailLength(int tailLength) {
        if (tailLength > 0) {
            OdtIdGenerator.tailLength = tailLength;
            tailNumber = (int)Math.pow(10.0, tailLength);
        }
    }

    public static String createId(String prefix) {
        OffsetDateTime odt = OffsetDateTime.now();
        String content = odt.format(formatter) + "-" + odt.getOffset().getTotalSeconds();
        long number = atomicLong.getAndIncrement() % (long)tailNumber;
        String suffix = StringUtils.leftPad((String)("" + number), (int)tailLength, (char)'0');
        return prefix + content + "-" + suffix;
    }

    public static String createId() {
        return OdtIdGenerator.createId("");
    }
}

