/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.ideahut.springboot.security.SecurityAuthorization;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public class SecurityAuthorizationFilter
extends OncePerRequestFilter {
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private Set<String> ignorePaths = new HashSet<String>();
    private SecurityAuthorization securityAuthorization;

    public SecurityAuthorizationFilter setSecurityAuthorization(SecurityAuthorization securityAuthorization) {
        this.securityAuthorization = securityAuthorization;
        return this;
    }

    public SecurityAuthorizationFilter setIgnorePaths(String ... paths) {
        if (paths != null) {
            this.ignorePaths.clear();
            for (String path : paths) {
                this.addIgnorePaths(path);
            }
        }
        return this;
    }

    public SecurityAuthorizationFilter addIgnorePaths(String path) {
        if (path != null) {
            this.ignorePaths.add(path);
        }
        return this;
    }

    public void afterPropertiesSet() throws ServletException {
        Assert.notNull((Object)this.securityAuthorization, (String)"securityAuthorization is required");
        super.afterPropertiesSet();
    }

    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        String path = request.getServletPath();
        for (String ignorePath : this.ignorePaths) {
            if (!this.antPathMatcher.match(ignorePath, path)) continue;
            return true;
        }
        return false;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        try {
            if (this.securityAuthorization.isRequestAuthorized(request, response)) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

