/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.context.RequestContext;
import net.ideahut.springboot.util.FrameworkUtil;
import net.ideahut.springboot.wrapper.RequestWrapper;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.MDC;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class DefaultRequestFilter
extends OncePerRequestFilter {
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private boolean initialized = false;
    private Map<String, String> corsHeaders;
    private Set<String> ignorePaths;
    private Boolean requestWrapperEnable;
    private Boolean traceEnable;
    private TraceGenerator traceGenerator;
    private String traceKey;

    public DefaultRequestFilter setCORSHeaders(Map<String, String> headers) {
        this.corsHeaders = headers != null ? new HashMap<String, String>(headers) : new HashMap<String, String>();
        return this;
    }

    public DefaultRequestFilter setCORSHeader(String key, String value) {
        if (this.corsHeaders == null) {
            this.corsHeaders = new HashMap<String, String>();
        }
        this.corsHeaders.put(key, value);
        return this;
    }

    public DefaultRequestFilter setIgnorePaths(String ... paths) {
        if (paths != null) {
            this.ignorePaths = new HashSet<String>();
            for (String path : paths) {
                this.ignorePaths.add(path);
            }
        }
        return this;
    }

    public DefaultRequestFilter setRequestWrapperEnable(Boolean requestWrapperEnable) {
        this.requestWrapperEnable = requestWrapperEnable;
        return this;
    }

    public DefaultRequestFilter setTraceEnable(Boolean traceEnable) {
        this.traceEnable = traceEnable;
        return this;
    }

    public DefaultRequestFilter setTraceGenerator(TraceGenerator traceGenerator) {
        this.traceGenerator = traceGenerator;
        return this;
    }

    public DefaultRequestFilter setTraceKey(String traceKey) {
        this.traceKey = traceKey;
        return this;
    }

    public DefaultRequestFilter initialize() {
        if (this.corsHeaders == null) {
            this.corsHeaders = new HashMap<String, String>();
        }
        if (this.ignorePaths == null) {
            this.ignorePaths = new HashSet<String>();
        }
        if (Boolean.TRUE.equals(this.traceEnable)) {
            String string = this.traceKey = this.traceKey != null ? this.traceKey.trim() : "";
            if (this.traceKey.isEmpty()) {
                this.traceKey = "traceId";
            }
            if (this.traceGenerator == null) {
                this.traceGenerator = () -> RandomStringUtils.randomAlphanumeric((int)6);
            }
        }
        this.initialized = true;
        return this;
    }

    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        this.initialized();
        String path = request.getServletPath();
        for (String ignorePath : this.ignorePaths) {
            if (!this.antPathMatcher.match(ignorePath, path)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        RequestContext.start();
        this.initialized();
        for (Map.Entry<String, String> entry : this.corsHeaders.entrySet()) {
            response.setHeader(entry.getKey(), entry.getValue());
        }
        if (HttpMethod.OPTIONS.name().equalsIgnoreCase(request.getMethod())) {
            response.setStatus(HttpStatus.OK.value());
            return;
        }
        HttpServletRequest newRequest = Boolean.TRUE.equals(this.requestWrapperEnable) ? new RequestWrapper(request) : request;
        RequestContext.setRequest((HttpServletRequest)newRequest);
        RequestContext.setResponse((HttpServletResponse)response);
        if (Boolean.TRUE.equals(this.traceEnable)) {
            try {
                MDC.put((String)this.traceKey, (String)this.traceGenerator.generateTraceValue());
                filterChain.doFilter((ServletRequest)newRequest, (ServletResponse)response);
            }
            finally {
                MDC.clear();
            }
        } else {
            filterChain.doFilter((ServletRequest)newRequest, (ServletResponse)response);
        }
    }

    private void initialized() {
        if (!this.initialized) {
            throw FrameworkUtil.exception(DefaultRequestFilter.class.getName() + " not initialized; call initialize() before using it");
        }
    }

    public static interface TraceGenerator {
        public String generateTraceValue();
    }
}

