/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import jakarta.persistence.EnumType;
import java.lang.reflect.Method;
import java.util.List;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.entity.AttributeOverrides;
import net.ideahut.springboot.entity.BasicDataType;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.entity.FieldBlob;
import net.ideahut.springboot.entity.FieldClob;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.JoinColumns;
import net.ideahut.springboot.util.FrameworkUtil;

interface NativeUpdateAppender {
    public void appendInsert(StringBuilder var1, StringBuilder var2, List<EntityNative.Parameter> var3, Object var4) throws Exception;

    public void appendUpdate(StringBuilder var1, List<EntityNative.Parameter> var2, Object var3) throws Exception;

    public static NativeUpdateAppender of(final FieldInfo info) {
        NativeUpdateAppender appender = null;
        if (info.hasAttributeOverrides()) {
            appender = new NativeUpdateAppender(){

                @Override
                public void appendInsert(StringBuilder sqlInto, StringBuilder sqlValues, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                    AttributeOverrides attributeOverrides = info.getAttributeOverrides();
                    for (String column : attributeOverrides.getColums()) {
                        NativeUpdateAppender.appendString(sqlInto, column, sqlValues);
                        parameters.add(attributeOverrides.getParameter(entity, column));
                    }
                }

                @Override
                public void appendUpdate(StringBuilder query, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                    AttributeOverrides attributeOverrides = info.getAttributeOverrides();
                    for (String column : attributeOverrides.getColums()) {
                        query.append(column).append("=?,");
                        parameters.add(attributeOverrides.getParameter(entity, column));
                    }
                }
            };
        } else if (info.hasJoinColumns()) {
            appender = new NativeUpdateAppender(){

                @Override
                public void appendInsert(StringBuilder sqlInto, StringBuilder sqlValues, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                    JoinColumns joinColumns = info.getJoinColumns();
                    for (String column : joinColumns.getColums()) {
                        NativeUpdateAppender.appendString(sqlInto, column, sqlValues);
                        parameters.add(joinColumns.getParameter(entity, column));
                    }
                }

                @Override
                public void appendUpdate(StringBuilder query, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                    JoinColumns joinColumns = info.getJoinColumns();
                    for (String column : joinColumns.getColums()) {
                        query.append(column).append("=?,");
                        parameters.add(joinColumns.getParameter(entity, column));
                    }
                }
            };
        } else if (info.getColumn() != null) {
            if (BasicDataType.isEqualJdbcType(info.getHibernateType(), BasicDataType.BLOB_TYPE)) {
                if (String.class.isAssignableFrom(info.getType())) {
                    appender = NativeUpdateAppender.stringBlobAppender(info);
                } else if (byte[].class.isAssignableFrom(info.getType())) {
                    appender = NativeUpdateAppender.bytesBlobAppender(info);
                }
            } else if (BasicDataType.isEqualJdbcType(info.getHibernateType(), BasicDataType.BINARY_TYPE)) {
                if (String.class.isAssignableFrom(info.getType())) {
                    appender = NativeUpdateAppender.stringBinaryAppender(info);
                } else if (byte[].class.isAssignableFrom(info.getType())) {
                    appender = NativeUpdateAppender.bytesBinaryAppender(info);
                }
            } else if (BasicDataType.isEqualJdbcType(info.getHibernateType(), BasicDataType.CLOB_TYPE)) {
                if (String.class.isAssignableFrom(info.getType())) {
                    appender = NativeUpdateAppender.stringClobAppender(info);
                } else if (byte[].class.isAssignableFrom(info.getType())) {
                    appender = NativeUpdateAppender.bytesClobAppender(info);
                }
            }
            if (appender == null) {
                appender = NativeUpdateAppender.defaultAppender(info);
            }
        } else {
            appender = new NativeUpdateAppender(){

                @Override
                public void appendInsert(StringBuilder sqlInto, StringBuilder sqlValues, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                }

                @Override
                public void appendUpdate(StringBuilder query, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                }
            };
        }
        return appender;
    }

    public static void appendString(StringBuilder sqlInto, String column, StringBuilder sqlValues) {
        sqlInto.append(column).append(",");
        sqlValues.append("?,");
    }

    public static NativeUpdateAppender defaultAppender(final FieldInfo info) {
        if (Converter.isEnum(info.getConverter())) {
            return NativeUpdateAppender.enumAppender(info);
        }
        return new NativeUpdateAppender(){

            @Override
            public void appendInsert(StringBuilder sqlInto, StringBuilder sqlValues, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                NativeUpdateAppender.appendString(sqlInto, info.getColumn().getName(), sqlValues);
                Object value = info.getValue(entity);
                parameters.add(EntityNative.Parameter.of(info.getHibernateType(), value));
            }

            @Override
            public void appendUpdate(StringBuilder query, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                query.append(info.getColumn().getName()).append("=?,");
                Object value = info.getValue(entity);
                parameters.add(EntityNative.Parameter.of(info.getHibernateType(), value));
            }
        };
    }

    public static NativeUpdateAppender enumAppender(final FieldInfo info) {
        Method method;
        try {
            method = info.getType().getMethod(EnumType.STRING == info.getEnumType() ? "name" : "ordinal", new Class[0]);
        }
        catch (Exception e) {
            throw FrameworkUtil.exception(e);
        }
        return new NativeUpdateAppender(){

            @Override
            public void appendInsert(StringBuilder sqlInto, StringBuilder sqlValues, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                NativeUpdateAppender.appendString(sqlInto, info.getColumn().getName(), sqlValues);
                Object value = info.getValue(entity);
                parameters.add(EntityNative.Parameter.of(info.getHibernateType(), value != null ? method.invoke(value, new Object[0]) : null));
            }

            @Override
            public void appendUpdate(StringBuilder query, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                query.append(info.getColumn().getName()).append("=?,");
                Object value = info.getValue(entity);
                parameters.add(EntityNative.Parameter.of(info.getHibernateType(), value != null ? method.invoke(value, new Object[0]) : null));
            }
        };
    }

    public static NativeUpdateAppender stringBlobAppender(final FieldInfo info) {
        return new NativeUpdateAppender(){

            @Override
            public void appendInsert(StringBuilder sqlInto, StringBuilder sqlValues, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                NativeUpdateAppender.appendString(sqlInto, info.getColumn().getName(), sqlValues);
                Object value = info.getValue(entity);
                parameters.add(EntityNative.Parameter.of(info.getHibernateType(), value != null ? new FieldBlob((String)value) : null));
            }

            @Override
            public void appendUpdate(StringBuilder query, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                query.append(info.getColumn().getName()).append("=?,");
                Object value = info.getValue(entity);
                parameters.add(EntityNative.Parameter.of(info.getHibernateType(), value != null ? new FieldBlob((String)value) : null));
            }
        };
    }

    public static NativeUpdateAppender stringBinaryAppender(final FieldInfo info) {
        return new NativeUpdateAppender(){

            @Override
            public void appendInsert(StringBuilder sqlInto, StringBuilder sqlValues, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                NativeUpdateAppender.appendString(sqlInto, info.getColumn().getName(), sqlValues);
                Object value = info.getValue(entity);
                parameters.add(EntityNative.Parameter.of(info.getHibernateType(), value != null ? ((String)value).getBytes() : null));
            }

            @Override
            public void appendUpdate(StringBuilder query, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                query.append(info.getColumn().getName()).append("=?,");
                Object value = info.getValue(entity);
                parameters.add(EntityNative.Parameter.of(info.getHibernateType(), value != null ? ((String)value).getBytes() : null));
            }
        };
    }

    public static NativeUpdateAppender stringClobAppender(final FieldInfo info) {
        return new NativeUpdateAppender(){

            @Override
            public void appendInsert(StringBuilder sqlInto, StringBuilder sqlValues, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                NativeUpdateAppender.appendString(sqlInto, info.getColumn().getName(), sqlValues);
                Object value = info.getValue(entity);
                parameters.add(EntityNative.Parameter.of(info.getHibernateType(), value != null ? new FieldClob((String)value) : null));
            }

            @Override
            public void appendUpdate(StringBuilder query, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                query.append(info.getColumn().getName()).append("=?,");
                Object value = info.getValue(entity);
                parameters.add(EntityNative.Parameter.of(info.getHibernateType(), value != null ? new FieldClob((String)value) : null));
            }
        };
    }

    public static NativeUpdateAppender bytesBlobAppender(final FieldInfo info) {
        return new NativeUpdateAppender(){

            @Override
            public void appendInsert(StringBuilder sqlInto, StringBuilder sqlValues, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                NativeUpdateAppender.appendString(sqlInto, info.getColumn().getName(), sqlValues);
                Object value = info.getValue(entity);
                parameters.add(EntityNative.Parameter.of(info.getHibernateType(), value != null ? new FieldBlob((byte[])value) : null));
            }

            @Override
            public void appendUpdate(StringBuilder query, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                query.append(info.getColumn().getName()).append("=?,");
                Object value = info.getValue(entity);
                parameters.add(EntityNative.Parameter.of(info.getHibernateType(), value != null ? new FieldBlob((byte[])value) : null));
            }
        };
    }

    public static NativeUpdateAppender bytesBinaryAppender(final FieldInfo info) {
        return new NativeUpdateAppender(){

            @Override
            public void appendInsert(StringBuilder sqlInto, StringBuilder sqlValues, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                NativeUpdateAppender.appendString(sqlInto, info.getColumn().getName(), sqlValues);
                Object value = info.getValue(entity);
                parameters.add(EntityNative.Parameter.of(info.getHibernateType(), value != null ? (byte[])value : null));
            }

            @Override
            public void appendUpdate(StringBuilder query, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                query.append(info.getColumn().getName()).append("=?,");
                Object value = info.getValue(entity);
                parameters.add(EntityNative.Parameter.of(info.getHibernateType(), value != null ? (byte[])value : null));
            }
        };
    }

    public static NativeUpdateAppender bytesClobAppender(final FieldInfo info) {
        return new NativeUpdateAppender(){

            @Override
            public void appendInsert(StringBuilder sqlInto, StringBuilder sqlValues, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                NativeUpdateAppender.appendString(sqlInto, info.getColumn().getName(), sqlValues);
                Object value = info.getValue(entity);
                parameters.add(EntityNative.Parameter.of(info.getHibernateType(), value != null ? new FieldClob((byte[])value) : null));
            }

            @Override
            public void appendUpdate(StringBuilder query, List<EntityNative.Parameter> parameters, Object entity) throws Exception {
                query.append(info.getColumn().getName()).append("=?,");
                Object value = info.getValue(entity);
                parameters.add(EntityNative.Parameter.of(info.getHibernateType(), value != null ? new FieldClob((byte[])value) : null));
            }
        };
    }
}

