/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.util.LinkedHashMap;
import java.util.Map;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.util.FrameworkUtil;

final class NativeEnumDefinition {
    private Map<String, Integer> nameOrdinalMap;
    private Map<Integer, String> ordinalNameMap;
    private Map<Enum<?>, Integer> objectOrdinalMap;
    private Map<Enum<?>, String> objectNameMap;

    private NativeEnumDefinition() {
    }

    protected static NativeEnumDefinition of(FieldInfo info) {
        if (Converter.isEnum(info.getConverter())) {
            NativeEnumDefinition definition = new NativeEnumDefinition();
            definition.nameOrdinalMap = new LinkedHashMap<String, Integer>();
            definition.ordinalNameMap = new LinkedHashMap<Integer, String>();
            definition.objectOrdinalMap = new LinkedHashMap();
            definition.objectNameMap = new LinkedHashMap();
            try {
                Enum[] values;
                for (Enum value : values = (Enum[])info.getType().getMethod("values", new Class[0]).invoke(null, new Object[0])) {
                    String name = (String)value.getClass().getMethod("name", new Class[0]).invoke((Object)value, new Object[0]);
                    Integer ordinal = (Integer)value.getClass().getMethod("ordinal", new Class[0]).invoke((Object)value, new Object[0]);
                    definition.nameOrdinalMap.put(name, ordinal);
                    definition.ordinalNameMap.put(ordinal, name);
                    definition.objectOrdinalMap.put(value, ordinal);
                    definition.objectNameMap.put(value, name);
                }
            }
            catch (Exception e) {
                throw FrameworkUtil.exception(e);
            }
            return definition;
        }
        return null;
    }

    public Map<String, Integer> getNameOrdinalMap() {
        return this.nameOrdinalMap;
    }

    public Map<Integer, String> getOrdinalNameMap() {
        return this.ordinalNameMap;
    }

    public Map<Enum<?>, Integer> getObjectOrdinalMap() {
        return this.objectOrdinalMap;
    }

    public Map<Enum<?>, String> getObjectNameMap() {
        return this.objectNameMap;
    }
}

