/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import java.util.UUID;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import org.hibernate.SharedSessionContract;
import org.hibernate.engine.spi.SharedSessionContractImplementor;

interface NativeAutoGeneratedId {
    public void setGeneratedId(SharedSessionContract var1, Object var2) throws Exception;

    public static NativeAutoGeneratedId of(EntityInfo entityInfo) {
        NativeAutoGeneratedId nativeAutoGeneratedId = null;
        final IdInfo idInfo = entityInfo.getIdInfo();
        if (EntityIdType.STANDARD == idInfo.getIdType()) {
            boolean isAutoGenerated;
            GeneratedValue generatedValue = idInfo.getGeneratedValue();
            boolean bl = isAutoGenerated = generatedValue != null && (GenerationType.IDENTITY.equals((Object)generatedValue.strategy()) || GenerationType.AUTO.equals((Object)generatedValue.strategy()));
            if (isAutoGenerated) {
                final FieldInfo idFieldInfo = entityInfo.getFieldInfo(idInfo.getFields().iterator().next());
                if (idInfo.getIdentifierGenerator() != null) {
                    nativeAutoGeneratedId = new NativeAutoGeneratedId(){

                        @Override
                        public void setGeneratedId(SharedSessionContract session, Object entity) throws Exception {
                            Object id = idInfo.getIdentifierGenerator().generate((SharedSessionContractImplementor)session, entity);
                            idFieldInfo.setValue(entity, id);
                        }
                    };
                } else if (idInfo.getGeneratedValue() != null) {
                    if (UUID.class.isAssignableFrom(idFieldInfo.getType())) {
                        nativeAutoGeneratedId = new NativeAutoGeneratedId(){

                            @Override
                            public void setGeneratedId(SharedSessionContract session, Object entity) throws Exception {
                                UUID id = UUID.randomUUID();
                                idFieldInfo.setValue(entity, id);
                            }
                        };
                    } else if ("uuid".equals(generatedValue.generator().toLowerCase())) {
                        nativeAutoGeneratedId = new NativeAutoGeneratedId(){

                            @Override
                            public void setGeneratedId(SharedSessionContract session, Object entity) throws Exception {
                                String id = UUID.randomUUID().toString();
                                idFieldInfo.setValue(entity, id);
                            }
                        };
                    } else if (GenerationType.IDENTITY.equals((Object)generatedValue.strategy()) || GenerationType.AUTO.equals((Object)generatedValue.strategy())) {
                        if (String.class.isAssignableFrom(idFieldInfo.getType())) {
                            nativeAutoGeneratedId = new NativeAutoGeneratedId(){

                                @Override
                                public void setGeneratedId(SharedSessionContract session, Object entity) throws Exception {
                                    String id = UUID.randomUUID().toString();
                                    idFieldInfo.setValue(entity, id);
                                }
                            };
                        } else if (Number.class.isAssignableFrom(idFieldInfo.getType()) || Long.TYPE == idFieldInfo.getType()) {
                            nativeAutoGeneratedId = new NativeAutoGeneratedId(){

                                @Override
                                public void setGeneratedId(SharedSessionContract session, Object entity) throws Exception {
                                    Long id = System.nanoTime();
                                    idFieldInfo.setValue(entity, id);
                                }
                            };
                        }
                    }
                }
            }
        }
        return nativeAutoGeneratedId;
    }
}

