/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.ideahut.springboot.context.RequestContext;
import net.ideahut.springboot.entity.DatabaseType;
import net.ideahut.springboot.entity.DepreHelper;
import net.ideahut.springboot.entity.EntityInfo0;
import net.ideahut.springboot.entity.EntityPostListener;
import net.ideahut.springboot.entity.EntityPreListener;
import net.ideahut.springboot.util.FrameworkUtil;
import org.hibernate.SessionFactory;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.internal.BootstrapContextImpl;
import org.hibernate.boot.internal.InFlightMetadataCollectorImpl;
import org.hibernate.boot.internal.MetadataBuilderImpl;
import org.hibernate.boot.internal.MetadataBuildingContextRootImpl;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.model.relational.internal.SqlStringGenerationContextImpl;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.env.internal.JdbcEnvironmentImpl;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

public final class EntityIntegrator {
    private static final String ENTITY_PRE_LISTENERS = "hibernate.entity_pre_listeners";
    private static final String ENTITY_POST_LISTENERS = "hibernate.entity_post_listeners";
    private static final String AUDIT_IDENTIFIER = "hibernate.audit_identifier";
    private static final String AUDIT_SESSION_FACTORY = "hibernate.audit_session_factory";
    private static final String AUDIT_BEAN_NAME = "hibernate.audit_bean_name";
    private static Map<Class<?>, List<Field>> compositeIds = new HashMap();
    private static Map<Class<?>, List<IdGenerator>> generatorIds = new HashMap();
    private final ServiceRegistry serviceRegistry;
    private final Map<String, Object> settings;
    private final MetadataBuildingContext metadataBuildingContext;
    private final Metadata metadata;
    private final MetadataSources metadataSources;
    private final SessionFactoryImplementor sessionFactory;
    private final Dialect dialect;
    private final DatabaseType databaseType;
    private final JdbcEnvironment jdbcEnvironment;
    private final SqlStringGenerationContext sqlStringGenerationContext;

    private EntityIntegrator(PlatformTransactionManager transactionManager, SessionFactory sessionFactory, Map<String, Object> settings, Collection<Class<?>> annotatedClasses) {
        Map<String, Object> settingsEi;
        Collection<Class<?>> annotatedClassesEi = null;
        if (transactionManager != null) {
            sae = new SettingsAndEntities(transactionManager);
            settingsEi = sae.settings;
            annotatedClassesEi = sae.entities;
        } else if (sessionFactory != null) {
            sae = new SettingsAndEntities(sessionFactory);
            settingsEi = sae.settings;
            annotatedClassesEi = sae.entities;
        } else {
            settingsEi = settings;
            annotatedClassesEi = annotatedClasses;
        }
        BootstrapServiceRegistry bootstrapServiceRegistry = new BootstrapServiceRegistryBuilder().enableAutoClose().build();
        StandardServiceRegistry serviceRegistryEi = new StandardServiceRegistryBuilder(bootstrapServiceRegistry).applySettings(settingsEi).build();
        MetadataSources metadataSourcesEi = new MetadataSources((ServiceRegistry)serviceRegistryEi);
        if (annotatedClassesEi != null) {
            for (Class<?> annotatedClass : annotatedClassesEi) {
                metadataSourcesEi.addAnnotatedClass(annotatedClass);
                EntityIntegrator.findCompositeAndGeneratorId(annotatedClass);
            }
        }
        this.serviceRegistry = serviceRegistryEi;
        this.metadataSources = metadataSourcesEi;
        this.metadata = this.metadataSources.buildMetadata();
        this.sessionFactory = (SessionFactoryImplementor)this.metadata.getSessionFactoryBuilder().build();
        this.dialect = this.sessionFactory.getJdbcServices().getDialect();
        this.databaseType = DatabaseType.of(this.dialect);
        this.settings = Collections.unmodifiableMap(settingsEi);
        this.jdbcEnvironment = new JdbcEnvironmentImpl((ServiceRegistryImplementor)this.serviceRegistry, this.metadata.getDatabase().getDialect());
        MetadataBuilderImpl.MetadataBuildingOptionsImpl metadataBuildingOptions = new MetadataBuilderImpl.MetadataBuildingOptionsImpl(serviceRegistryEi);
        BootstrapContextImpl bootstrapContext = new BootstrapContextImpl(serviceRegistryEi, (MetadataBuildingOptions)metadataBuildingOptions);
        metadataBuildingOptions.setBootstrapContext((BootstrapContext)bootstrapContext);
        InFlightMetadataCollectorImpl metadataCollector = new InFlightMetadataCollectorImpl((BootstrapContext)bootstrapContext, (MetadataBuildingOptions)metadataBuildingOptions);
        this.metadataBuildingContext = new MetadataBuildingContextRootImpl("", (BootstrapContext)bootstrapContext, (MetadataBuildingOptions)metadataBuildingOptions, (InFlightMetadataCollector)metadataCollector);
        this.sqlStringGenerationContext = SqlStringGenerationContextImpl.fromConfigurationMap((JdbcEnvironment)this.jdbcEnvironment, (Database)this.metadata.getDatabase(), this.settings);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    public JdbcEnvironment getJdbcEnvironment() {
        return this.jdbcEnvironment;
    }

    public MetadataBuildingContext getMetadataBuildingContext() {
        return this.metadataBuildingContext;
    }

    public SqlStringGenerationContext getSqlStringGenerationContext() {
        return this.sqlStringGenerationContext;
    }

    public Map<String, Object> getSettings() {
        return this.settings;
    }

    public Collection<Class<?>> getAnnotatedClasses() {
        return this.metadataSources.getAnnotatedClasses();
    }

    public Connection getConnection() throws SQLException {
        return ((ConnectionProvider)this.sessionFactory.getSessionFactoryOptions().getServiceRegistry().getService(ConnectionProvider.class)).getConnection();
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    protected DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    protected void destroy() {
        StandardServiceRegistryBuilder.destroy((ServiceRegistry)this.serviceRegistry);
    }

    public static EntityIntegrator of(SessionFactory sessionFactory) {
        return new EntityIntegrator(null, sessionFactory, null, null);
    }

    public static EntityIntegrator of(Map<String, Object> settings, Collection<Class<?>> annotatedClasses) {
        return new EntityIntegrator(null, null, settings, annotatedClasses);
    }

    public static EntityIntegrator of(Map<String, Object> settings) {
        return new EntityIntegrator(null, null, settings, null);
    }

    public static EntityIntegrator of(PlatformTransactionManager transactionManager) {
        return new EntityIntegrator(transactionManager, null, null, null);
    }

    protected static List<Field> getCompositeIds(Class<?> entityClass) {
        return compositeIds.get(entityClass);
    }

    protected static boolean hasIdGenerator(Class<?> entityClass) {
        return generatorIds.containsKey(entityClass);
    }

    protected static void setEntityPreListeners(EntityManagerFactory entityManagerFactory, List<EntityPreListener> entityPreListeners) {
        if (entityManagerFactory != null && entityPreListeners != null) {
            entityManagerFactory.getProperties().put(ENTITY_PRE_LISTENERS, entityPreListeners);
        }
    }

    protected static void setEntityPostListeners(EntityManagerFactory entityManagerFactory, List<EntityPostListener> entityPostListeners) {
        if (entityManagerFactory != null && entityPostListeners != null) {
            entityManagerFactory.getProperties().put(ENTITY_POST_LISTENERS, entityPostListeners);
        }
    }

    private static void findCompositeAndGeneratorId(Class<?> entityClass) {
        HashSet<Field> compositeIdFields = new HashSet<Field>();
        HashSet<IdGenerator> generatorIdFields = new HashSet<IdGenerator>();
        for (Class<?> theClass = entityClass; theClass != null; theClass = theClass.getSuperclass()) {
            for (Field field : theClass.getDeclaredFields()) {
                Id id = EntityInfo0.getAnnotation(Id.class, field);
                if (id == null) continue;
                compositeIdFields.add(field);
                GenericGenerator genericGenerator = EntityInfo0.getAnnotation(GenericGenerator.class, field);
                GeneratedValue generatedValue = EntityInfo0.getAnnotation(GeneratedValue.class, field);
                if (genericGenerator == null && generatedValue == null) continue;
                generatorIdFields.add(new IdGenerator(field, genericGenerator, generatedValue));
            }
        }
        if (compositeIdFields.size() > 1 && compositeIds.getOrDefault(entityClass, null) == null) {
            ArrayList<Field> fields = new ArrayList<Field>();
            for (Field field : compositeIdFields) {
                field.setAccessible(true);
                fields.add(field);
            }
            compositeIds.put(entityClass, Collections.unmodifiableList(fields));
        }
        if (!generatorIdFields.isEmpty() && generatorIds.getOrDefault(entityClass, null) == null) {
            generatorIds.put(entityClass, Collections.unmodifiableList(new ArrayList(generatorIdFields)));
        }
    }

    protected static EntityManagerFactory entityManagerFactory(PlatformTransactionManager transactionManager) {
        try {
            return (EntityManagerFactory)transactionManager.getClass().getMethod("getEntityManagerFactory", new Class[0]).invoke((Object)transactionManager, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static SessionFactory sessionFactory(PlatformTransactionManager transactionManager) {
        try {
            return (SessionFactory)transactionManager.getClass().getMethod("getSessionFactory", new Class[0]).invoke((Object)transactionManager, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void setActiveSessionFactory(SessionFactory sessionFactory) {
        RequestContext.currentContext().setAttribute(EntityIntegrator.class.getName() + "::ActiveSessionFactory", (Object)sessionFactory);
    }

    public static SessionFactory getActiveSessionFactory() {
        return (SessionFactory)RequestContext.currentContext().getAttribute(EntityIntegrator.class.getName() + "::ActiveSessionFactory");
    }

    public static String getAuditIdentifier() {
        return EntityIntegrator.getAuditIdentifier(EntityIntegrator.getActiveSessionFactory());
    }

    public static String getAuditIdentifier(SessionFactory sessionFactory) {
        if (sessionFactory == null) {
            return "";
        }
        String auditIdentifier = (String)sessionFactory.getProperties().get(AUDIT_IDENTIFIER);
        return auditIdentifier != null ? auditIdentifier : "";
    }

    public static SessionFactory getAuditSessionFactory(SessionFactory sessionFactory) {
        if (sessionFactory == null) {
            return null;
        }
        return (SessionFactory)sessionFactory.getProperties().get(AUDIT_SESSION_FACTORY);
    }

    public static void setAuditSessionFactory(String auditId, Map<String, Object> settings, SessionFactory auditSessionFactory) {
        String idAudit = auditId != null ? String.valueOf(auditId).trim() : "";
        Assert.hasLength((String)idAudit, (String)"Audit ID is required");
        Assert.isTrue((boolean)Pattern.matches("[a-z0-9]+(?:_[a-z0-9]+)*", idAudit), (String)"Invalid Audit ID pattern");
        settings.put(AUDIT_IDENTIFIER, idAudit);
        if (auditSessionFactory != null) {
            settings.put(AUDIT_SESSION_FACTORY, auditSessionFactory);
        }
    }

    public static void setAuditSessionFactory(String auditId, Map<String, Object> settings) {
        EntityIntegrator.setAuditSessionFactory(auditId, settings, null);
    }

    public static void setAuditSessionFactory(String auditId, EntityManagerFactory entityManagerFactory, SessionFactory auditSessionFactory) {
        EntityIntegrator.setAuditSessionFactory(auditId, entityManagerFactory.getProperties(), auditSessionFactory);
    }

    public static void setAuditSessionFactory(String auditId, EntityManagerFactory entityManagerFactory) {
        EntityIntegrator.setAuditSessionFactory(auditId, entityManagerFactory, null);
    }

    public static String getAuditBeanName(SessionFactory sessionFactory) {
        if (sessionFactory == null) {
            return null;
        }
        return (String)sessionFactory.getProperties().get(AUDIT_BEAN_NAME);
    }

    public static List<EntityPreListener> getEntityPreListeners(SessionFactory sessionFactory) {
        List listeners = (List)sessionFactory.getProperties().get(ENTITY_PRE_LISTENERS);
        if (listeners != null) {
            EntityIntegrator.setActiveSessionFactory(sessionFactory);
        }
        return listeners;
    }

    public static List<EntityPostListener> getEntityPostListeners(SessionFactory sessionFactory) {
        List listeners = (List)sessionFactory.getProperties().get(ENTITY_POST_LISTENERS);
        if (listeners != null) {
            EntityIntegrator.setActiveSessionFactory(sessionFactory);
        }
        return listeners;
    }

    private static final class SettingsAndEntities {
        private Map<String, Object> settings;
        private Set<Class<?>> entities = new HashSet();

        private SettingsAndEntities(PlatformTransactionManager transactionManager) {
            Metamodel metamodel;
            EntityManagerFactory entityManagerFactory = EntityIntegrator.entityManagerFactory(transactionManager);
            if (entityManagerFactory != null) {
                this.settings = entityManagerFactory.getProperties();
                metamodel = entityManagerFactory.getMetamodel();
            } else {
                SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)EntityIntegrator.sessionFactory(transactionManager);
                if (sessionFactory != null) {
                    Metamodel metamodelEi;
                    this.settings = sessionFactory.getProperties();
                    metamodel = metamodelEi = DepreHelper.getMetamodel(sessionFactory);
                } else {
                    throw FrameworkUtil.exception("Unsupported Transaction Manager: " + transactionManager.getClass());
                }
            }
            if (this.settings == null) {
                this.settings = new HashMap<String, Object>();
            }
            if (metamodel != null) {
                for (EntityType entityType : metamodel.getEntities()) {
                    this.entities.add(entityType.getJavaType());
                }
            }
        }

        private SettingsAndEntities(SessionFactory sessionFactory) {
            Metamodel metamodel = DepreHelper.getMetamodel((SessionFactoryImplementor)sessionFactory);
            this.settings = sessionFactory.getProperties();
            for (EntityType entityType : metamodel.getEntities()) {
                this.entities.add(entityType.getJavaType());
            }
        }
    }

    private static final class IdGenerator {
        private final Field field;
        private final GenericGenerator genericGenerator;
        private final GeneratedValue generatedValue;

        IdGenerator(Field field, GenericGenerator genericGenerator, GeneratedValue generatedValue) {
            this.field = field;
            this.genericGenerator = genericGenerator;
            this.generatedValue = generatedValue;
        }

        public Field getField() {
            return this.field;
        }

        public GenericGenerator getGenericGenerator() {
            return this.genericGenerator;
        }

        public GeneratedValue getGeneratedValue() {
            return this.generatedValue;
        }
    }
}

