/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.util.List;
import net.ideahut.springboot.entity.DatabaseType;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.InIdsQuery;
import net.ideahut.springboot.util.FrameworkUtil;

final class EntityInIdsQuery {
    protected static DatabaseType.InIdsQueryCreator None = new DatabaseType.InIdsQueryCreator(){

        @Override
        public InIdsQuery createInIdsQuery(EntityInfo entityInfo) {
            return new InIdsQuery(){

                @Override
                public String getInIdsQuery(List<Object> ids, String alias, List parameters, Integer startIndex) {
                    return "";
                }
            };
        }
    };
    protected static DatabaseType.InIdsQueryCreator Standard;
    protected static DatabaseType.InIdsQueryCreator Embedded;

    private EntityInIdsQuery() {
    }

    protected static InIdsQuery of(EntityInfo entityInfo) {
        DatabaseType databaseType = entityInfo.getTrxManagerInfo().getIntegrator().getDatabaseType();
        return databaseType.getInIdsQueryCreators().getEntityInIdsQueryCreator(entityInfo.getIdInfo().getIdType()).createInIdsQuery(entityInfo);
    }

    static {
        Embedded = Standard = new DatabaseType.InIdsQueryCreator(){

            @Override
            public InIdsQuery createInIdsQuery(EntityInfo entityInfo) {
                IdInfo idInfo = entityInfo.getIdInfo();
                final String idField = idInfo.getFields().iterator().next();
                return new InIdsQuery(){

                    @Override
                    public String getInIdsQuery(List<Object> ids, String alias, List parameters, Integer startIndex) {
                        String query = EntityHelper.aliasField(alias, idField) + " in (?" + (parameters.size() + startIndex) + ")";
                        parameters.add(ids);
                        return query;
                    }
                };
            }
        };
    }

    protected static class Composite {
        protected static DatabaseType.InIdsQueryCreator INLINE = new DatabaseType.InIdsQueryCreator(){

            @Override
            public InIdsQuery createInIdsQuery(final EntityInfo entityInfo) {
                final IdInfo idInfo = entityInfo.getIdInfo();
                return new InIdsQuery(){

                    @Override
                    public String getInIdsQuery(List<Object> ids, String alias, List parameters, Integer startIndex) {
                        try {
                            Object query = "(";
                            for (Object id : ids) {
                                for (String name : idInfo.getFields()) {
                                    query = (String)query + EntityHelper.aliasField(alias, name) + "=?" + (parameters.size() + startIndex) + " and ";
                                    parameters.add(entityInfo.getFieldInfo(name).getValue(id));
                                }
                                query = ((String)query).substring(0, ((String)query).length() - 5);
                                query = (String)query + " or ";
                            }
                            query = ((String)query).substring(0, ((String)query).length() - 4);
                            query = (String)query + ")";
                            return query;
                        }
                        catch (Exception e) {
                            throw FrameworkUtil.exception(e);
                        }
                    }
                };
            }
        };
        protected static DatabaseType.InIdsQueryCreator BRACKET = new DatabaseType.InIdsQueryCreator(){

            @Override
            public InIdsQuery createInIdsQuery(final EntityInfo entityInfo) {
                final IdInfo idInfo = entityInfo.getIdInfo();
                return new InIdsQuery(){

                    @Override
                    public String getInIdsQuery(List<Object> ids, String alias, List parameters, Integer startIndex) {
                        try {
                            Object fieldQl = "(";
                            for (String name : idInfo.getFields()) {
                                fieldQl = (String)fieldQl + EntityHelper.aliasField(alias, name) + ",";
                            }
                            fieldQl = ((String)fieldQl).substring(0, ((String)fieldQl).length() - 1);
                            fieldQl = (String)fieldQl + ")";
                            Object valueQl = "(";
                            for (Object id : ids) {
                                Object paramQl = "(";
                                for (String name : idInfo.getFields()) {
                                    paramQl = (String)paramQl + "?" + (parameters.size() + startIndex) + ",";
                                    parameters.add(entityInfo.getFieldInfo(name).getValue(id));
                                }
                                paramQl = ((String)paramQl).substring(0, ((String)paramQl).length() - 1);
                                paramQl = (String)paramQl + ")";
                                valueQl = (String)valueQl + (String)paramQl + ",";
                            }
                            valueQl = ((String)valueQl).substring(0, ((String)valueQl).length() - 1);
                            valueQl = (String)valueQl + ")";
                            return "(" + (String)fieldQl + " in " + (String)valueQl + ")";
                        }
                        catch (Exception e) {
                            throw FrameworkUtil.exception(e);
                        }
                    }
                };
            }
        };

        protected Composite() {
        }
    }
}

