/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import jakarta.persistence.metamodel.Metamodel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.entity.EntityAudit;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.EntitySoftDelete;
import org.hibernate.Session;
import org.hibernate.SharedSessionContract;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.Query;
import org.hibernate.tuple.NonIdentifierAttribute;

final class DepreHelper {
    private DepreHelper() {
    }

    protected static <T> Iterable<T> getListeners(EventListenerGroup<T> group) {
        return group.listeners();
    }

    protected static <R> Query<R> createNativeQuery(SharedSessionContract session, String sql, Class<R> resultClass) {
        return session.createNativeQuery(sql, resultClass);
    }

    protected static Query createNativeQuery(SharedSessionContract session, String sql) {
        return session.createNativeQuery(sql);
    }

    protected static String getCheckConstraint(Column column) {
        return column.getCheckConstraint();
    }

    protected static Iterator<String> getCheckConstraintsIterator(Table table) {
        return table.getCheckConstraintsIterator();
    }

    protected static Iterator<Index> getIndexIterator(Table table) {
        return table.getIndexes().values().iterator();
    }

    protected static Iterator<UniqueKey> getUniqueKeyIterator(Table table) {
        return table.getUniqueKeyIterator();
    }

    protected static Iterator<ForeignKey> getForeignKeyIterator(Table table) {
        return table.getForeignKeyIterator();
    }

    protected static List<Column> getIndexColumns(Index index) {
        return index.getColumns();
    }

    protected static Map<Column, String> getIndexColumnOrderMap(Index index) {
        return index.getColumnOrderMap();
    }

    protected static String getGenericGeneratorStrategy(GenericGenerator genericGenerator) {
        String strategy = genericGenerator.strategy();
        return strategy != null ? strategy.trim() : "";
    }

    protected static IdentifierGenerator newUUIDGenerator() {
        return new UUIDGenerator();
    }

    protected static Metamodel getMetamodel(SessionFactoryImplementor sessionFactory) {
        return sessionFactory.getMetamodel();
    }

    protected static String sqlCreateForeignKey(EntityIntegrator integrator, ForeignKey foreignKey, String defaultCatalog, String defaultSchema) {
        Dialect dialect = integrator.getDialect();
        SqlStringGenerationContext context = integrator.getSqlStringGenerationContext();
        String constraintString = foreignKey.sqlConstraintString(context, foreignKey.getName(), defaultCatalog, defaultSchema);
        if (!StringHelper.isEmpty((String)constraintString)) {
            String tableName = foreignKey.getTable().getQualifiedName(context);
            return dialect.getAlterTableString(tableName) + " " + constraintString;
        }
        return null;
    }

    protected static Map<String, Integer> getStateIndexes(Object entity, EntityPersister persister) {
        HashSet<String> names = new HashSet<String>();
        if (entity instanceof EntityAudit) {
            names.addAll(EntityAudit.Name.Field.list());
        }
        if (entity instanceof EntitySoftDelete) {
            names.add("deletedOn");
        }
        HashMap<String, Integer> indexes = new HashMap<String, Integer>();
        NonIdentifierAttribute[] na = persister.getEntityMetamodel().getProperties();
        for (int i = 0; i < na.length; ++i) {
            if (!names.contains(na[i].getName())) continue;
            indexes.put(na[i].getName(), i);
        }
        return indexes;
    }

    protected static void update(Session session, Object entity) {
        session.update(entity);
    }
}

