/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import net.ideahut.springboot.crud.Match;
import net.ideahut.springboot.crud.Relation;
import net.ideahut.springboot.entity.EntityInfo;
import org.springframework.util.Assert;

public class Join {
    private String name;
    private Integer replica;
    private String store;
    private List<String> fields;
    private List<Relation> relations;
    private Match match;
    private Boolean select;
    @JsonIgnore
    private EntityInfo entityInfo;

    private Join() {
    }

    public Join setName(String name) {
        this.name = name;
        return this;
    }

    public Join setReplica(Integer replica) {
        this.replica = replica;
        return this;
    }

    public Join setStore(String store) {
        this.store = store;
        return this;
    }

    public Join setFields(List<String> fields) {
        this.fields = fields;
        return this;
    }

    public Join addField(String field) {
        if (this.fields == null) {
            this.fields = new ArrayList<String>();
        }
        this.fields.add(field);
        return this;
    }

    public Join setRelations(List<Relation> relations) {
        this.relations = relations;
        return this;
    }

    public Join addRelation(Relation relation) {
        if (this.relations == null) {
            this.relations = new ArrayList<Relation>();
        }
        this.relations.add(relation);
        return this;
    }

    public Join setMatch(Match match) {
        this.match = match;
        return this;
    }

    public Join setSelect(Boolean select) {
        this.select = select;
        return this;
    }

    protected Join setEntityInfo(EntityInfo entityInfo) {
        this.entityInfo = entityInfo;
        return this;
    }

    public static Join of(EntityInfo entityInfo, Relation relation) {
        Assert.notNull((Object)entityInfo, (String)"EntityInfo is required");
        Join join = new Join().setEntityInfo(entityInfo);
        if (relation != null) {
            join.addRelation(relation);
        }
        return join;
    }

    public static Join of(EntityInfo entityInfo) {
        return Join.of(entityInfo, null);
    }

    public static Join of(String name, Relation relation) {
        Assert.hasLength((String)name, (String)"Name is required");
        Join join = new Join().setName(name);
        if (relation != null) {
            join.addRelation(relation);
        }
        return join;
    }

    public static Join of(String name) {
        return Join.of(name, null);
    }

    public String getName() {
        return this.name;
    }

    public Integer getReplica() {
        return this.replica;
    }

    public String getStore() {
        return this.store;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public List<Relation> getRelations() {
        return this.relations;
    }

    public Match getMatch() {
        return this.match;
    }

    public Boolean getSelect() {
        return this.select;
    }

    public EntityInfo getEntityInfo() {
        return this.entityInfo;
    }
}

