/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.crud.Condition;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.crud.CrudSelectEntity0;
import net.ideahut.springboot.crud.DepreHelper;
import net.ideahut.springboot.crud.Filter;
import net.ideahut.springboot.crud.Logical;
import net.ideahut.springboot.crud.Relation;
import net.ideahut.springboot.crud.Stack;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntitySoftDelete;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.object.MapStringObject;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.util.Assert;

final class CrudUpdateEntity0 {
    private CrudUpdateEntity0() {
    }

    protected static List<Stack> saveStacks(Session session, EntityInfo entityInfo, CrudRequest crudRequest, Object parent, boolean isUpdate) throws Exception {
        List<Stack> items = crudRequest.getStacks();
        if (items != null && !items.isEmpty()) {
            ArrayList<Stack> stacks = new ArrayList<Stack>();
            for (Stack item : items) {
                if (item.getValues() == null || item.getValues().isEmpty()) continue;
                Stack stack = Stack.of(item.getEntityInfo()).setName(item.getName()).setReplica(item.getReplica()).setEntities(new ArrayList<Object>());
                MapStringObject mref = new MapStringObject();
                for (Relation relation : item.getRelations()) {
                    FieldInfo fiSource = entityInfo.getFieldInfo(relation.getSource());
                    Assert.notNull((Object)fiSource, (String)("Invalid stack relation, 1, stack: " + stack.getName() + ", relation: " + CrudHelper0.writeAsString(relation)));
                    Object viSource = fiSource.getValue(parent);
                    FieldInfo fiTarget = stack.getEntityInfo().getFieldInfo(relation.getTarget());
                    Assert.notNull((Object)fiTarget, (String)("Invalid stack relation, 2, stack: " + stack.getName() + ", relation: " + CrudHelper0.writeAsString(relation)));
                    if (Converter.isEntity(fiTarget.getConverter())) {
                        Assert.isTrue((boolean)fiTarget.getType().equals(entityInfo.getEntityClass()), (String)("Invalid stack relation, 3, stack: " + stack.getName() + ", relation: " + CrudHelper0.writeAsString(relation)));
                        Object viTarget = entityInfo.createEntity();
                        fiSource.setValue(viTarget, viSource);
                        mref.put(relation.getTarget(), viTarget);
                        continue;
                    }
                    mref.put(relation.getTarget(), viSource);
                }
                for (MapStringObject value : item.getValues()) {
                    MapStringObject newValue = new MapStringObject(value);
                    newValue.putAll((Map)mref);
                    Object entity = CrudUpdateEntity0.saveStack(session, entityInfo, parent, stack, newValue, item.getRelations(), isUpdate);
                    stack.getEntities().add(entity);
                }
                stacks.add(stack);
            }
            return stacks;
        }
        return null;
    }

    private static Object saveStack(Session session, EntityInfo entityInfo, Object parent, Stack stack, MapStringObject value, List<Relation> relations, boolean isUpdate) throws Exception {
        Object entity = CrudHelper0.mapToObject(value, stack.getEntityInfo().getEntityClass());
        if (isUpdate) {
            Object idValue = CrudHelper0.idFromEntity(stack.getEntityInfo(), entity);
            Assert.notNull((Object)idValue, (String)("Stack id is required, stack: " + stack.getName() + ", value: " + CrudHelper0.writeAsString(value)));
            IdInfo idInfo = stack.getEntityInfo().getIdInfo();
            if (EntityIdType.COMPOSITE == idInfo.getIdType()) {
                String hql = "from " + stack.getEntityInfo().getEntityClass().getSimpleName() + " where 1=1 ";
                int i = 1;
                for (String string : idInfo.getFields()) {
                    hql = hql + "and " + string + "=?" + i;
                    ++i;
                }
                Query query = session.createQuery(hql, Object.class);
                i = 1;
                for (String field : idInfo.getFields()) {
                    query.setParameter(i, stack.getEntityInfo().getFieldInfo(field).getValue(idValue));
                    ++i;
                }
                entity = query.uniqueResult();
            } else {
                entity = session.get(stack.getEntityInfo().getEntityClass(), (Object)((Serializable)idValue));
            }
            if (entity == null) {
                throw new Exception("Stack entity is not found, stack: " + stack.getName() + ", value: " + CrudHelper0.writeAsString(value));
            }
            stack.getEntityInfo().getTrxManagerInfo().loadLazy(entity, stack.getEntityInfo().getEntityClass());
            HashSet<String> skipFields = new HashSet<String>(stack.getEntityInfo().getIdInfo().getFields());
            for (Relation relation : relations) {
                FieldInfo fieldInfo = entityInfo.getFieldInfo(relation.getSource());
                Object viSource = fieldInfo.getValue(parent);
                FieldInfo fiTarget = stack.getEntityInfo().getFieldInfo(relation.getTarget());
                Object viTarget = fiTarget.getValue(entity);
                if (Converter.isEntity(fiTarget.getConverter())) {
                    Object idTarget = CrudHelper0.idFromEntity(entityInfo, viTarget);
                    if (viSource != null && idTarget != null && !viSource.equals(idTarget)) {
                        Assert.isTrue((boolean)false, (String)("Invalid stack relation value, 1, stack: " + stack.getName() + ", value: " + CrudHelper0.writeAsString(value)));
                    }
                } else if (viSource != null && viTarget != null && !viSource.equals(viTarget)) {
                    Assert.isTrue((boolean)false, (String)("Invalid stack relation value, 2, stack: " + stack.getName() + ", value: " + CrudHelper0.writeAsString(value)));
                }
                skipFields.add(relation.getTarget());
            }
            stack.getEntityInfo().merge(value, entity, skipFields);
            DepreHelper.update(session, entity);
        } else {
            EntityHelper.setAudit(entity, false);
            DepreHelper.saveOrUpdate(session, entity);
            stack.getEntityInfo().getTrxManagerInfo().loadLazy(entity, stack.getEntityInfo().getEntityClass());
        }
        return entity;
    }

    protected static HqlParameters hqlParametersByIds(CrudRequest crudRequest, int startIndex) {
        EntityInfo entityInfo = crudRequest.getEntityInfo();
        ArrayList<Object> parameters = new ArrayList<Object>();
        String inIds = CrudSelectEntity0.inIds(crudRequest.getIds(), entityInfo, "", parameters, startIndex);
        if (inIds.isEmpty()) {
            return null;
        }
        Object whereQl = "where 1=1 ";
        if (EntitySoftDelete.class.isAssignableFrom(entityInfo.getEntityClass())) {
            whereQl = (String)whereQl + "and deletedOn is null ";
        }
        whereQl = (String)whereQl + "and " + inIds + " ";
        Condition.QueryParameters queryAndParameters = Condition.QueryParameters.of((String)whereQl, parameters);
        CrudUpdateEntity0.spesifics(crudRequest, queryAndParameters);
        return new HqlParameters(entityInfo, queryAndParameters.getQuery(), queryAndParameters.getParameters(), startIndex);
    }

    private static void spesifics(CrudRequest crudRequest, Condition.QueryParameters queryParameters) {
        if (crudRequest.getSpesifics() != null) {
            for (Filter filter : crudRequest.getSpesifics()) {
                CrudUpdateEntity0.filter(filter, crudRequest.getEntityInfo(), queryParameters);
            }
        }
    }

    private static void filter(Filter filter, EntityInfo entityInfo, Condition.QueryParameters queryParameters) {
        Logical logical = filter.getLogical();
        if (logical == null) {
            logical = Logical.AND;
        }
        String logic = " " + logical.name().toLowerCase();
        StringBuilder query = new StringBuilder(queryParameters.getQuery());
        if (filter.getFilters() != null && !filter.getFilters().isEmpty()) {
            query.append(" ").append(logic).append(" (1=1 ");
            for (Filter child : filter.getFilters()) {
                queryParameters.setQuery(query.toString());
                CrudUpdateEntity0.filter(child, entityInfo, queryParameters);
                query = new StringBuilder(queryParameters.getQuery());
            }
            query.append(") ");
            queryParameters.setQuery(query.toString());
            return;
        }
        String field = filter.getField();
        Assert.notNull((Object)field, (String)"Filter field is required");
        Condition condition = filter.getCondition();
        Assert.notNull((Object)condition, (String)"Filter condition is required");
        ArrayList<Object> lvals = new ArrayList<Object>();
        if (condition.isConvert()) {
            for (Object svalue : filter.getValues()) {
                Object ovalue = EntityHelper.getFieldValue(entityInfo, field, svalue != null ? "" + svalue : null);
                lvals.add(ovalue);
            }
        } else {
            for (Object svalue : filter.getValues()) {
                lvals.add(svalue);
            }
        }
        Condition.QueryParameters qap = condition.getBuilder().build(false, logic, queryParameters.getParameters().size(), field, lvals.toArray());
        query.append(qap.getQuery());
        queryParameters.getParameters().addAll(qap.getParameters());
        queryParameters.setQuery(query.toString());
    }

    protected static class HqlParameters {
        private final EntityInfo entityInfo;
        private final String whereQl;
        private final List<Object> parameters;
        private final int startIndex;

        protected HqlParameters(EntityInfo entityInfo, String whereQl, List<Object> parameters, int startIndex) {
            this.entityInfo = entityInfo;
            this.whereQl = whereQl;
            this.parameters = parameters != null ? Collections.unmodifiableList(parameters) : null;
            this.startIndex = startIndex;
        }

        protected String selectQl() {
            return "from " + this.entityClass().getSimpleName() + " " + this.whereQl;
        }

        protected String deleteQl() {
            return "delete from " + this.entityClass().getSimpleName() + " " + this.whereQl;
        }

        protected String whereQl() {
            return this.whereQl;
        }

        protected Class<?> entityClass() {
            return this.entityInfo.getEntityClass();
        }

        protected void applyParameters(Query<?> query) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                query.setParameter(this.startIndex + i, this.parameters.get(i));
            }
        }
    }
}

