/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.crud.CrudResult;
import net.ideahut.springboot.crud.CrudSelect;
import net.ideahut.springboot.crud.CrudSelect0;
import net.ideahut.springboot.crud.CrudSelectEntity0;
import net.ideahut.springboot.crud.DepreHelper;
import net.ideahut.springboot.crud.Filter;
import net.ideahut.springboot.crud.Join;
import net.ideahut.springboot.crud.Relation;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.entity.EntitySoftDelete;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.SessionCallable;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.object.Page;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.util.Assert;

final class CrudSelectEntity
implements CrudSelect {
    private EntityInfo entityInfo;
    private String alias;
    private List<EntityNative.Select> selects;
    private Integer maxLimit = 100;
    private CrudRequest crudRequest;
    private CrudSelect0.Ql hql;
    private List<Object> parameters;
    private Map<String, CrudSelect0.SelectJoin> selectJoins;

    protected CrudSelectEntity() {
    }

    @Override
    public void destroy() {
        this.entityInfo = null;
        this.alias = null;
        this.selects = null;
        this.maxLimit = null;
        this.crudRequest = null;
        this.hql = null;
        this.parameters = null;
        this.selectJoins = null;
    }

    public static CrudSelectEntity of(CrudRequest crudRequest) {
        boolean isSoftDelete;
        CrudSelectEntity crudSelect = new CrudSelectEntity();
        crudSelect.crudRequest = crudRequest;
        crudSelect.entityInfo = crudRequest.getEntityInfo();
        crudSelect.selects = new ArrayList<EntityNative.Select>();
        crudSelect.hql = new CrudSelect0.Ql();
        ArrayList<Object> parameters = new ArrayList<Object>();
        Integer maxLimit = crudRequest.getMaxLimit();
        if (maxLimit != null && maxLimit > 0) {
            crudSelect.maxLimit = maxLimit;
        }
        StringBuilder fromQl = new StringBuilder("from ").append(crudSelect.entityInfo.getEntityClass().getSimpleName()).append(" ");
        HashMap<String, CrudSelect0.SelectJoin> selectJoins = new HashMap<String, CrudSelect0.SelectJoin>();
        List<Join> cjoins = crudRequest.getJoins();
        boolean hasJoin = cjoins != null && !cjoins.isEmpty();
        crudSelect.alias = hasJoin ? "a0" : null;
        int idxSelect = 0;
        StringBuilder selectQl = new StringBuilder();
        List<String> selFields = crudRequest.getFields();
        if (selFields != null && !selFields.isEmpty()) {
            select = EntityNative.Select.of(crudSelect.entityInfo, idxSelect, null);
            for (String selField : selFields) {
                FieldInfo fieldInfo = select.getEntityInfo().getFieldInfo(selField);
                Assert.notNull((Object)fieldInfo, (String)("Unknown field: " + select.getEntityInfo().getEntityClass().getSimpleName() + "." + selField));
                selectQl.append(EntityHelper.aliasField(crudSelect.alias, selField)).append(",");
                select.getFields().add(fieldInfo);
                ++idxSelect;
            }
            crudSelect.selects.add(select);
            selectQl = new StringBuilder("select ").append((CharSequence)selectQl.deleteCharAt(selectQl.length() - 1));
        } else if (hasJoin) {
            select = EntityNative.Select.of(crudSelect.entityInfo, idxSelect, null);
            crudSelect.selects.add(select);
            selectQl.append("select ").append(crudSelect.alias);
            ++idxSelect;
        }
        if (hasJoin) {
            fromQl.append(crudSelect.alias).append(" ");
            int i = 1;
            for (Join cjoin : cjoins) {
                EntityInfo cEtInfo = cjoin.getEntityInfo();
                String jalias = "a" + i;
                fromQl.append(cjoin.getMatch().getJoin()).append(" join ").append(cEtInfo.getEntityClass().getSimpleName()).append(" ").append(jalias).append(" on ");
                List<Relation> crelations = cjoin.getRelations();
                for (Relation crelation : crelations) {
                    fromQl.append(jalias).append(".").append(crelation.getTarget()).append("=");
                    if (crelation.getSource() != null) {
                        Set<String> idFields;
                        EntityInfo eiSource;
                        FieldInfo fSrcInfo = crudSelect.entityInfo.getFieldInfo(crelation.getSource());
                        Object concatId = "";
                        if (fSrcInfo != null && Converter.isEntity(fSrcInfo.getConverter()) && (eiSource = crudSelect.entityInfo.getTrxManagerInfo().getEntityInfo(fSrcInfo.getType())) != null && (idFields = eiSource.getIdInfo().getFields()).size() == 1) {
                            concatId = "." + idFields.iterator().next();
                        }
                        fromQl.append(crudSelect.alias).append(".").append(crelation.getSource()).append((String)concatId).append(" ");
                    } else {
                        fromQl.append("?").append(parameters.size() + 1).append(" ");
                        parameters.add(crelation.getValue());
                    }
                    fromQl.append("and ");
                }
                fromQl.delete(fromQl.length() - 4, fromQl.length());
                if (Boolean.TRUE.equals(cjoin.getSelect())) {
                    FieldInfo store = crudSelect.entityInfo.getFieldInfo(cjoin.getStore());
                    if (store == null) {
                        store = crudSelect.entityInfo.getFieldTransient(cjoin.getStore());
                    }
                    Assert.notNull((Object)store, (String)("Unknown store field " + crudSelect.entityInfo.getEntityClass().getSimpleName() + "." + cjoin.getStore() + ", for join: " + cjoin.getName()));
                    if (cjoin.getFields() != null && !cjoin.getFields().isEmpty()) {
                        select = EntityNative.Select.of(cEtInfo, idxSelect, store);
                        for (String cfield : cjoin.getFields()) {
                            selectQl.append(",").append(EntityHelper.aliasField(jalias, cfield));
                            FieldInfo fieldInfo = select.getEntityInfo().getFieldInfo(cfield);
                            Assert.notNull((Object)fieldInfo, (String)("Unknown field: " + select.getEntityInfo().getEntityClass().getSimpleName() + "." + cfield));
                            select.getFields().add(fieldInfo);
                            ++idxSelect;
                        }
                        crudSelect.selects.add(select);
                    } else {
                        select = EntityNative.Select.of(cEtInfo, idxSelect, store);
                        crudSelect.selects.add(select);
                        selectQl.append(",").append(jalias);
                        ++idxSelect;
                    }
                }
                selectJoins.put(cjoin.getName(), CrudSelect0.SelectJoin.of(cEtInfo, jalias, cjoin));
                ++i;
            }
        }
        crudSelect.hql.setSelect(selectQl.toString());
        crudSelect.hql.setFrom(fromQl.toString().trim());
        StringBuilder whereQl = new StringBuilder("where ");
        Boolean isIgnoreSoftDelete = EntitySoftDelete.isIgnore();
        boolean bl = isSoftDelete = EntitySoftDelete.class.isAssignableFrom(crudSelect.entityInfo.getEntityClass()) && (isIgnoreSoftDelete == null || !Boolean.TRUE.equals(isIgnoreSoftDelete));
        if (isSoftDelete) {
            whereQl.append(EntityHelper.aliasField(crudSelect.alias, "deletedOn")).append(" is null ");
        } else {
            whereQl.append("1=1 ");
        }
        crudSelect.hql.setWhere(whereQl.toString());
        if (crudRequest.getSpesifics() != null) {
            for (Filter filter : crudRequest.getSpesifics()) {
                CrudSelectEntity0.filter(filter, crudSelect.entityInfo, crudSelect.alias, crudSelect.hql, parameters, selectJoins);
            }
        }
        crudSelect.parameters = Collections.unmodifiableList(parameters);
        crudSelect.selectJoins = Collections.unmodifiableMap(selectJoins);
        return crudSelect;
    }

    @Override
    public CrudResult page() {
        String inIds;
        final CrudRequest crudRequest = CrudRequest.copy(this.crudRequest);
        final CrudSelect0.Ql hql = CrudHelper0.copy(this.hql, CrudSelect0.Ql.class);
        final ArrayList<Object> parameters = new ArrayList<Object>(this.parameters);
        final CrudSelect0.StartLimit startLimit = CrudSelect0.StartLimit.of(crudRequest, this.maxLimit);
        Page page = crudRequest.getPage();
        if (page == null) {
            page = Page.empty();
        }
        page.setIndex(startLimit.getIndex());
        page.setSize(startLimit.getLimit());
        final Boolean count = page.getCount();
        List<Filter> filters = crudRequest.getFilters();
        if (filters != null && !filters.isEmpty()) {
            for (Filter filter : filters) {
                CrudSelectEntity0.filter(filter, this.entityInfo, this.alias, hql, parameters, this.selectJoins);
            }
        }
        if (!(inIds = CrudSelectEntity0.inIds(crudRequest.getIds(), this.entityInfo, this.alias, parameters, 1)).isEmpty()) {
            hql.setWhere(hql.getWhere() + " and " + inIds);
        }
        CrudSelectEntity0.orderOf(crudRequest.getOrders(), hql, this.alias, this.selectJoins);
        TrxManagerInfo trxManagerInfo = this.entityInfo.getTrxManagerInfo();
        Object[] data = trxManagerInfo.transaction(new SessionCallable<Object[]>(){

            @Override
            public Object[] call(Session session) throws Exception {
                int i;
                Query query;
                Long records = null;
                if (Boolean.TRUE.equals(count)) {
                    query = DepreHelper.createQuery(session, "select count(1) " + hql.getFrom() + " " + hql.getWhere());
                    for (i = 0; i < parameters.size(); ++i) {
                        query.setParameter(i + 1, parameters.get(i));
                    }
                    records = Long.valueOf("" + query.getSingleResult());
                    if (records == 0L) {
                        return new Object[]{records, null};
                    }
                }
                query = DepreHelper.createQuery(session, hql.getSelect() + " " + hql.getFrom() + " " + hql.getWhere() + " " + hql.getOrder());
                for (i = 0; i < parameters.size(); ++i) {
                    query.setParameter(i + 1, parameters.get(i));
                }
                query.setFirstResult(startLimit.getStart().intValue());
                query.setMaxResults(startLimit.getLimit().intValue());
                List rows = query.getResultList();
                List<Object> list = CrudSelectEntity0.entitesOf(rows, CrudSelectEntity.this.entityInfo, CrudSelectEntity.this.selects, crudRequest.getLoads());
                return new Object[]{records, list};
            }
        });
        return CrudResult.success((Object)page.setRecords((Long)data[0]).setData((List)data[1]));
    }

    @Override
    public CrudResult list() {
        String inIds;
        final CrudRequest crudRequest = CrudRequest.copy(this.crudRequest);
        final CrudSelect0.Ql hql = CrudHelper0.copy(this.hql, CrudSelect0.Ql.class);
        final ArrayList<Object> parameters = new ArrayList<Object>(this.parameters);
        final CrudSelect0.StartLimit startLimit = CrudSelect0.StartLimit.of(crudRequest, this.maxLimit);
        List<Filter> filters = crudRequest.getFilters();
        if (filters != null && !filters.isEmpty()) {
            for (Filter filter : filters) {
                CrudSelectEntity0.filter(filter, this.entityInfo, this.alias, hql, parameters, this.selectJoins);
            }
        }
        if (!(inIds = CrudSelectEntity0.inIds(crudRequest.getIds(), this.entityInfo, this.alias, parameters, 1)).isEmpty()) {
            hql.setWhere(hql.getWhere() + " and " + inIds);
        }
        CrudSelectEntity0.orderOf(crudRequest.getOrders(), hql, this.alias, this.selectJoins);
        TrxManagerInfo trxManagerInfo = this.entityInfo.getTrxManagerInfo();
        List data = trxManagerInfo.transaction(new SessionCallable<List>(){

            @Override
            public List call(Session session) throws Exception {
                Query query = DepreHelper.createQuery(session, hql.getSelect() + " " + hql.getFrom() + " " + hql.getWhere() + " " + hql.getOrder());
                for (int i = 0; i < parameters.size(); ++i) {
                    query.setParameter(i + 1, parameters.get(i));
                }
                query.setFirstResult(startLimit.getStart().intValue());
                query.setMaxResults(startLimit.getLimit().intValue());
                List rows = query.getResultList();
                return CrudSelectEntity0.entitesOf(rows, CrudSelectEntity.this.entityInfo, CrudSelectEntity.this.selects, crudRequest.getLoads());
            }
        });
        return CrudResult.success((Object)data);
    }

    @Override
    public CrudResult single() {
        CrudRequest crudRequest = CrudRequest.copy(this.crudRequest);
        CrudSelect0.Ql hql = CrudHelper0.copy(this.hql, CrudSelect0.Ql.class);
        ArrayList<Object> parameters = new ArrayList<Object>(this.parameters);
        Object entity = CrudSelectEntity0.single(this.entityInfo, this.alias, crudRequest, this.selects, hql, parameters, this.selectJoins, false);
        return CrudResult.success((Object)entity);
    }

    @Override
    public CrudResult unique() {
        CrudRequest crudRequest = CrudRequest.copy(this.crudRequest);
        CrudSelect0.Ql hql = CrudHelper0.copy(this.hql, CrudSelect0.Ql.class);
        ArrayList<Object> parameters = new ArrayList<Object>(this.parameters);
        Object entity = CrudSelectEntity0.single(this.entityInfo, this.alias, crudRequest, this.selects, hql, parameters, this.selectJoins, true);
        return CrudResult.success((Object)entity);
    }

    @Override
    public CrudResult map() {
        List data = (List)this.list().getValue();
        MapStringObject map = CrudSelect0.listToMap(data, this.entityInfo, this.crudRequest);
        return CrudResult.success((Object)map);
    }
}

