/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.ideahut.springboot.crud.CrudBuilder0;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.crud.Filter;
import net.ideahut.springboot.crud.Join;
import net.ideahut.springboot.crud.Stack;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.object.Page;
import org.springframework.util.Assert;

public class CrudRest {
    private final CrudRequest request;
    private Boolean prettyPrint;

    private CrudRest() {
        this(null);
    }

    private CrudRest(CrudRequest request) {
        this.request = request;
    }

    public CrudRest setReplica(Integer replica) {
        CrudBuilder0.checkReplica(replica);
        this.request.setReplica(replica);
        return this;
    }

    public CrudRest setIds(List<Object> ids) {
        if (ids != null) {
            this.request.setIds(new ArrayList<Object>());
            for (Object id : ids) {
                this.request.getIds().add(id);
            }
        }
        return this;
    }

    public CrudRest setId(Object id) {
        this.request.setIds(Arrays.asList(id));
        return this;
    }

    public CrudRest setMapKeys(List<String> keys) {
        if (this.request.getMap() == null) {
            this.request.setMap(new CrudRequest.MapConfig());
        }
        this.request.getMap().setKeys(keys);
        return this;
    }

    public CrudRest setMapFlat(Boolean flat) {
        if (this.request.getMap() == null) {
            this.request.setMap(new CrudRequest.MapConfig());
        }
        this.request.getMap().setFlat(flat);
        return this;
    }

    public CrudRest setPage(Page page) {
        this.request.setPage(page);
        return this;
    }

    public CrudRest setStart(Integer start) {
        this.request.setStart(start);
        return this;
    }

    public CrudRest setLimit(Integer limit) {
        this.request.setLimit(limit);
        return this;
    }

    public CrudRest setFilters(List<Filter> filters) {
        this.request.setFilters(filters);
        return this;
    }

    public CrudRest addFilter(Filter filter) {
        if (this.request.getFilters() == null) {
            this.request.setFilters(new ArrayList<Filter>());
        }
        this.request.getFilters().add(filter);
        return this;
    }

    public CrudRest setOrders(List<String> orders) {
        this.request.setOrders(orders);
        return this;
    }

    public CrudRest addOrder(String order) {
        if (this.request.getOrders() == null) {
            this.request.setOrders(new ArrayList<String>());
        }
        this.request.getOrders().add(order);
        return this;
    }

    public CrudRest setFields(List<String> fields) {
        this.request.setFields(fields);
        return this;
    }

    public CrudRest addField(String field) {
        if (this.request.getFields() == null) {
            this.request.setFields(new ArrayList<String>());
        }
        this.request.getFields().add(field);
        return this;
    }

    public CrudRest setLoads(List<String> loads) {
        this.request.setLoads(loads);
        return this;
    }

    public CrudRest addLoad(String load) {
        if (this.request.getLoads() == null) {
            this.request.setLoads(new ArrayList<String>());
        }
        this.request.getLoads().add(load);
        return this;
    }

    public CrudRest setValues(List<Object> values) {
        if (values != null) {
            this.request.setValues(new ArrayList<MapStringObject>());
            for (Object value : values) {
                CrudBuilder0.checkValue(this.request.getEntityInfo(), value);
                this.request.getValues().add(CrudBuilder0.convertValue(value));
            }
        } else {
            this.request.setValues(null);
        }
        return this;
    }

    public CrudRest setValue(Object value) {
        CrudBuilder0.checkValue(this.request.getEntityInfo(), value);
        this.request.setValues(new ArrayList<MapStringObject>());
        this.request.getValues().add(CrudBuilder0.convertValue(value));
        return this;
    }

    public CrudRest addValue(Object value) {
        CrudBuilder0.checkValue(this.request.getEntityInfo(), value);
        if (this.request.getValues() == null) {
            this.request.setValues(new ArrayList<MapStringObject>());
        }
        this.request.getValues().add(CrudBuilder0.convertValue(value));
        return this;
    }

    public CrudRest setJoins(List<Join> joins) {
        if (joins != null) {
            this.request.setJoins(new ArrayList<Join>());
            for (Join join : joins) {
                CrudBuilder0.checkJoin(join);
                this.request.getJoins().add(join);
            }
        } else {
            this.request.setJoins(null);
        }
        return this;
    }

    public CrudRest addJoin(Join join) {
        CrudBuilder0.checkJoin(join);
        if (this.request.getJoins() == null) {
            this.request.setJoins(new ArrayList<Join>());
        }
        this.request.getJoins().add(join);
        return this;
    }

    public CrudRest setStacks(List<Stack> stacks) {
        if (stacks != null) {
            this.request.setStacks(new ArrayList<Stack>());
            for (Stack stack : stacks) {
                CrudBuilder0.checkStack(stack);
                this.request.getStacks().add(stack);
            }
        } else {
            this.request.setStacks(null);
        }
        return this;
    }

    public CrudRest addStack(Stack stack) {
        CrudBuilder0.checkStack(stack);
        if (this.request.getStacks() == null) {
            this.request.setStacks(new ArrayList<Stack>());
        }
        this.request.getStacks().add(stack);
        return this;
    }

    public CrudRest setPrettyPrint(Boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        return this;
    }

    public CrudRequest getRequest() {
        return this.request;
    }

    public String toJsonString() {
        return CrudHelper0.Mapper.nuller.writeAsString(this.toJsonNode(), 1, Boolean.TRUE.equals(this.prettyPrint));
    }

    public byte[] toJsonBytes() {
        return CrudHelper0.Mapper.nuller.writeAsBytes(this.toJsonNode(), 1, Boolean.TRUE.equals(this.prettyPrint));
    }

    public String toXmlString() {
        return CrudHelper0.Mapper.nuller.writeAsString(this.toJsonNode(), 2, Boolean.TRUE.equals(this.prettyPrint));
    }

    public byte[] toXmlBytes() {
        return CrudHelper0.Mapper.nuller.writeAsBytes(this.toJsonNode(), 2, Boolean.TRUE.equals(this.prettyPrint));
    }

    public JsonNode toJsonNode() {
        List<Stack> stacks;
        ObjectNode node = CrudHelper0.Mapper.nonull.convert((Object)this.request, ObjectNode.class);
        List<MapStringObject> values = this.request.getValues();
        if (values != null) {
            ArrayNode jvalues = (ArrayNode)node.get("values");
            for (int i = 0; i < values.size(); ++i) {
                jvalues.set(i, CrudHelper0.Mapper.nuller.convert((Object)values.get(i), JsonNode.class));
            }
        }
        if ((stacks = this.request.getStacks()) != null) {
            ArrayNode jstacks = (ArrayNode)node.get("stacks");
            for (int i = 0; i < stacks.size(); ++i) {
                Stack stack = stacks.get(i);
                List<MapStringObject> svals = stack.getValues();
                if (svals == null) continue;
                ArrayNode jvals = (ArrayNode)jstacks.get(i).get("values");
                for (int j = 0; j < svals.size(); ++j) {
                    jvals.set(j, CrudHelper0.Mapper.nuller.convert((Object)svals.get(j), JsonNode.class));
                }
            }
        }
        return node;
    }

    public static CrudRest of(String name) {
        Assert.hasLength((String)name, (String)"Name is required");
        CrudRequest request = CrudRequest.of(name);
        return new CrudRest(request);
    }
}

