/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.entity.EntityInfo;

public class CrudProps {
    @JsonIgnore
    private EntityInfo entityInfo;
    private Boolean useNative;
    private Integer maxLimit;
    private Boolean enableStack;
    private Boolean enableLoad;
    private Set<String> selectFields;

    public CrudRequest setToRequest(CrudRequest request) {
        if (request != null) {
            if (Boolean.TRUE.equals(this.useNative)) {
                request.setUseNative(Boolean.TRUE);
            }
            if (Boolean.FALSE.equals(this.enableStack)) {
                request.setStacks(null);
            }
            if (Boolean.FALSE.equals(this.enableLoad)) {
                request.setLoads(null);
            }
            if (this.selectFields != null && !this.selectFields.isEmpty()) {
                List<String> reqFields = request.getFields();
                if (reqFields != null && !reqFields.isEmpty()) {
                    ArrayList<String> newFields = new ArrayList<String>();
                    for (String field : reqFields) {
                        if (!this.selectFields.contains(field)) continue;
                        newFields.add(field);
                    }
                    request.setFields(newFields);
                } else {
                    request.setFields(new ArrayList<String>(this.selectFields));
                }
            }
            request.setMaxLimit(this.maxLimit);
        }
        return request;
    }

    @JsonIgnore
    public void setEntityInfo(EntityInfo entityInfo) {
        this.entityInfo = entityInfo;
    }

    public void setUseNative(Boolean useNative) {
        this.useNative = useNative;
    }

    public void setMaxLimit(Integer maxLimit) {
        this.maxLimit = maxLimit;
    }

    public void setEnableStack(Boolean enableStack) {
        this.enableStack = enableStack;
    }

    public void setEnableLoad(Boolean enableLoad) {
        this.enableLoad = enableLoad;
    }

    public void setSelectFields(Set<String> selectFields) {
        this.selectFields = selectFields;
    }

    public EntityInfo getEntityInfo() {
        return this.entityInfo;
    }

    public Boolean getUseNative() {
        return this.useNative;
    }

    public Integer getMaxLimit() {
        return this.maxLimit;
    }

    public Boolean getEnableStack() {
        return this.enableStack;
    }

    public Boolean getEnableLoad() {
        return this.enableLoad;
    }

    public Set<String> getSelectFields() {
        return this.selectFields;
    }
}

