/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import net.ideahut.springboot.crud.CrudHandler;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.CrudProps;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.crud.CrudResource;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.object.MapStringObject;
import org.springframework.util.Assert;

final class CrudHelperServlet {
    private CrudHelperServlet() {
    }

    public static CrudRequest getRequest(CrudHandler handler, HttpServletRequest request) {
        String page;
        String sid;
        Integer replica;
        String sreplica;
        Assert.notNull((Object)handler, (String)"CrudHandler is required");
        CrudResource resource = handler.getCrudResource();
        Assert.notNull((Object)resource, (String)"CrudHandler.Resource is required");
        EntityTrxManager entityTrxManager = handler.getEntityTrxManager();
        Assert.notNull((Object)entityTrxManager, (String)"EntityTrxManager is required");
        String manager = request.getParameter("manager");
        TrxManagerInfo trxManagerInfo = entityTrxManager.getDefaultTrxManagerInfo();
        if (!manager.isEmpty()) {
            trxManagerInfo = entityTrxManager.getTrxManagerInfo(manager);
            Assert.notNull((Object)trxManagerInfo, (String)("Manager is not found: " + manager));
        }
        String name = request.getParameter("name");
        Assert.hasLength((String)name, (String)"Name is required");
        CrudProps props = resource.getCrudProps(trxManagerInfo.getName(), name);
        Assert.notNull((Object)props, (String)("CrudProps is not found, name: " + name));
        EntityInfo entityInfo = props.getEntityInfo();
        Assert.notNull((Object)entityInfo, (String)("EntityInfo is not found, name: " + name));
        CrudRequest crudRequest = CrudRequest.of(entityInfo);
        crudRequest.setManager(trxManagerInfo.getName());
        crudRequest.setName(name);
        String string = sreplica = request.getParameter("replica") != null ? request.getParameter("replica").trim() : "";
        if (!sreplica.isEmpty() && (replica = Integer.valueOf(sreplica)) > 0) {
            crudRequest.setReplica(replica);
            crudRequest.setUseNative(Boolean.TRUE);
        }
        if ((sid = request.getParameter("id")) != null) {
            Object id = CrudHelper0.idFromString(entityInfo, sid);
            if (id != null) {
                crudRequest.setIds(new ArrayList<Object>());
                crudRequest.getIds().add(id);
            }
        } else {
            String[] sids = request.getParameterValues("ids");
            if (sids != null) {
                crudRequest.setIds(new ArrayList<Object>());
                for (String cid : sids) {
                    Object id = CrudHelper0.idFromString(entityInfo, cid);
                    if (id == null) continue;
                    crudRequest.getIds().add(id);
                }
            }
        }
        String smap = request.getParameter("map");
        if (smap != null) {
            String[] ss;
            CrudRequest.MapConfig map = new CrudRequest.MapConfig();
            for (String s : ss = smap.split("~~")) {
                int idx = s.indexOf(":");
                if (idx == -1) continue;
                String key = s.substring(0, idx).trim();
                String str = s.substring(idx + 1);
                if ("key".equals(key)) {
                    map.setKeys(new ArrayList<String>());
                    map.getKeys().add(str);
                    continue;
                }
                if ("keys".equals(key)) {
                    map.setKeys(CrudHelper0.stringToList(str));
                    continue;
                }
                if (!"flat".equals(key)) continue;
                String lcase = str.trim().toLowerCase();
                map.setFlat(!"0".equals(lcase) && !"false".equals(lcase));
            }
        }
        if ((page = request.getParameter("page")) != null) {
            crudRequest.setPage(CrudHelper0.stringToPage(page));
        } else {
            String limit;
            String start = request.getParameter("start");
            if (start != null && !(start = start.trim()).isEmpty()) {
                crudRequest.setStart(Integer.valueOf(start));
            }
            if ((limit = request.getParameter("limit")) != null && !(limit = limit.trim()).isEmpty()) {
                crudRequest.setLimit(Integer.valueOf(limit));
            }
        }
        crudRequest.setFilters(CrudHelper0.stringToFilters(request.getParameter("filters")));
        crudRequest.setOrders(CrudHelper0.stringToList(request.getParameter("orders")));
        crudRequest.setFields(CrudHelper0.stringToList(request.getParameter("fields")));
        if (!Boolean.FALSE.equals(props.getEnableLoad())) {
            crudRequest.setLoads(CrudHelper0.stringToList(request.getParameter("loads")));
        }
        MapStringObject value = CrudHelper0.stringToMap(request.getParameter("value"));
        crudRequest.setValues(new ArrayList<MapStringObject>());
        crudRequest.getValues().add(value);
        return props.setToRequest(crudRequest);
    }
}

