/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import java.util.UUID;
import net.ideahut.springboot.converter.Converter;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.UUIDJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.UUIDJdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class UUIDConverter
extends Converter {
    private static final BasicType<UUID> TYPE = new BasicTypeImpl((JavaType)UUIDJavaType.INSTANCE, (JdbcType)UUIDJdbcType.INSTANCE);

    protected UUIDConverter() {
    }

    private UUIDConverter(Class<?> type, Object ... args) {
        super(type, new Object[0]);
        UUIDConverter.isEqual(UUID.class, type);
    }

    @Override
    protected Object valueOf(Object value) {
        return UUID.fromString("" + value);
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return UUID.class.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return TYPE;
    }

    @Override
    protected Object nullValue() {
        return null;
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new UUIDConverter(type, args);
    }
}

