/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import net.ideahut.springboot.converter.Converter;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.IntegerJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.IntegerJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class PrimitiveIntegerConverter
extends Converter {
    private static final BasicType<Integer> TYPE = new BasicTypeImpl((JavaType)IntegerJavaType.INSTANCE, (JdbcType)IntegerJdbcType.INSTANCE);

    protected PrimitiveIntegerConverter() {
    }

    private PrimitiveIntegerConverter(Class<?> type, Object ... args) {
        super(type, new Object[0]);
        PrimitiveIntegerConverter.isEqual(Integer.TYPE, type);
    }

    @Override
    protected Object valueOf(Object value) {
        String input = ("" + value).trim();
        return !input.isEmpty() ? Integer.valueOf(Integer.parseInt(input)) : this.nullValue();
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return Integer.TYPE.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return TYPE;
    }

    @Override
    protected Object nullValue() {
        return 0;
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new PrimitiveIntegerConverter(type, args);
    }
}

