/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import net.ideahut.springboot.converter.Converter;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.DoubleJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.DoubleJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class PrimitiveDoubleConverter
extends Converter {
    private static final BasicType<Double> TYPE = new BasicTypeImpl((JavaType)DoubleJavaType.INSTANCE, (JdbcType)DoubleJdbcType.INSTANCE);

    protected PrimitiveDoubleConverter() {
    }

    private PrimitiveDoubleConverter(Class<?> type, Object ... args) {
        super(type, new Object[0]);
        PrimitiveDoubleConverter.isEqual(Double.TYPE, type);
    }

    @Override
    protected Object valueOf(Object value) {
        String input = ("" + value).trim();
        return !input.isEmpty() ? Double.valueOf(Double.parseDouble(input)) : this.nullValue();
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return Double.TYPE.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return TYPE;
    }

    @Override
    protected Object nullValue() {
        return 0.0;
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new PrimitiveDoubleConverter(type, args);
    }
}

