/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import net.ideahut.springboot.converter.Converter;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.ByteJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.TinyIntJdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class PrimitiveByteConverter
extends Converter {
    private static final BasicType<Byte> TYPE = new BasicTypeImpl((JavaType)ByteJavaType.INSTANCE, (JdbcType)TinyIntJdbcType.INSTANCE);

    protected PrimitiveByteConverter() {
    }

    private PrimitiveByteConverter(Class<?> type, Object ... args) {
        super(type, new Object[0]);
        PrimitiveByteConverter.isEqual(Byte.TYPE, type);
    }

    @Override
    protected Object valueOf(Object value) {
        String input = ("" + value).trim();
        return !input.isEmpty() ? Byte.valueOf(input) : this.nullValue();
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return Byte.TYPE.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return TYPE;
    }

    @Override
    protected Object nullValue() {
        return 0;
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new PrimitiveByteConverter(type, args);
    }
}

