/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import net.ideahut.springboot.converter.Converter;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.BooleanJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BooleanJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class PrimitiveBooleanConverter
extends Converter {
    private static final BasicType<Boolean> TYPE = new BasicTypeImpl((JavaType)BooleanJavaType.INSTANCE, (JdbcType)BooleanJdbcType.INSTANCE);

    protected PrimitiveBooleanConverter() {
    }

    private PrimitiveBooleanConverter(Class<?> type, Object ... args) {
        super(type, new Object[0]);
        PrimitiveBooleanConverter.isEqual(Boolean.TYPE, type);
    }

    @Override
    protected Object valueOf(Object value) {
        String input = ("" + value).trim();
        return !"0".equals(input) && !"false".equalsIgnoreCase(input);
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return Boolean.TYPE.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return TYPE;
    }

    @Override
    protected Object nullValue() {
        return false;
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new PrimitiveBooleanConverter(type, args);
    }
}

