/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import net.ideahut.springboot.converter.Converter;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.FloatJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.FloatJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class FloatConverter
extends Converter {
    private static final BasicType<Float> TYPE = new BasicTypeImpl((JavaType)FloatJavaType.INSTANCE, (JdbcType)FloatJdbcType.INSTANCE);

    protected FloatConverter() {
    }

    private FloatConverter(Class<?> type, Object ... args) {
        super(type, new Object[0]);
        FloatConverter.isEqual(Float.class, type);
    }

    @Override
    protected Object valueOf(Object value) {
        String input = ("" + value).trim();
        return !input.isEmpty() ? Float.valueOf(Float.parseFloat(input)) : this.nullValue();
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return Float.class.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return TYPE;
    }

    @Override
    protected Object nullValue() {
        return null;
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new FloatConverter(type, args);
    }
}

