/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import net.ideahut.springboot.converter.Converter;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.DoubleJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.DoubleJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class DoubleConverter
extends Converter {
    private static final BasicType<Double> TYPE = new BasicTypeImpl((JavaType)DoubleJavaType.INSTANCE, (JdbcType)DoubleJdbcType.INSTANCE);

    protected DoubleConverter() {
    }

    private DoubleConverter(Class<?> type, Object ... args) {
        super(type, new Object[0]);
        DoubleConverter.isEqual(Double.class, type);
    }

    @Override
    protected Object valueOf(Object value) {
        String input = ("" + value).trim();
        return !input.isEmpty() ? Double.valueOf(Double.parseDouble(input)) : this.nullValue();
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return Double.class.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return TYPE;
    }

    @Override
    protected Object nullValue() {
        return null;
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new DoubleConverter(type, args);
    }
}

