/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.config.DepreHelper;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public abstract class BasicWebMvcConfig
implements WebMvcConfigurer {
    private static final List<MediaType> DEFAULT_MEDIA_TYPE = Collections.singletonList(MediaType.APPLICATION_JSON);

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        String parameterName = this.parameterName();
        parameterName = parameterName != null ? parameterName.trim() : "";
        configurer.parameterName(parameterName).favorParameter(!parameterName.isEmpty());
        DepreHelper.configurePathExtension(configurer, this.enableExtension());
        boolean enableAcceptHeader = this.enableAcceptHeader();
        configurer.ignoreAcceptHeader(!enableAcceptHeader);
        configurer.defaultContentType(new MediaType[]{DEFAULT_MEDIA_TYPE.get(0)});
        Map<String, MediaType> mediaTypes = this.mediaTypes();
        if (mediaTypes != null) {
            configurer.mediaTypes(mediaTypes);
            if (!mediaTypes.containsKey("xml")) {
                configurer.mediaType("xml", MediaType.APPLICATION_XML);
            }
            if (!mediaTypes.containsKey("json")) {
                configurer.mediaType("json", MediaType.APPLICATION_JSON);
            }
            if (!mediaTypes.containsKey("txt")) {
                configurer.mediaType("txt", MediaType.TEXT_PLAIN);
            }
        } else {
            configurer.mediaType("xml", MediaType.APPLICATION_XML).mediaType("json", MediaType.APPLICATION_JSON).mediaType("txt", MediaType.TEXT_PLAIN);
        }
        configurer.defaultContentTypeStrategy((ContentNegotiationStrategy)new InternalContentNegotiationStrategy());
        super.configureContentNegotiation(configurer);
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        DataMapper dataMapper = this.dataMapper();
        if (dataMapper == null) {
            dataMapper = new DataMapperImpl();
        }
        converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter((ObjectMapper)dataMapper.mapper(1)));
        converters.add((HttpMessageConverter<?>)new MappingJackson2XmlHttpMessageConverter((ObjectMapper)dataMapper.mapper(2)));
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        super.configureMessageConverters(converters);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        HandlerInterceptor[] handlerInterceptors = this.handlerInterceptors();
        if (handlerInterceptors != null) {
            for (HandlerInterceptor handlerInterceptor : handlerInterceptors) {
                registry.addInterceptor(handlerInterceptor);
            }
        }
        super.addInterceptors(registry);
    }

    protected abstract String parameterName();

    protected abstract boolean enableExtension();

    protected abstract boolean enableAcceptHeader();

    protected abstract DataMapper dataMapper();

    protected abstract HandlerInterceptor[] handlerInterceptors();

    protected abstract Map<String, MediaType> mediaTypes();

    private static class InternalContentNegotiationStrategy
    implements ContentNegotiationStrategy {
        private InternalContentNegotiationStrategy() {
        }

        public List<MediaType> resolveMediaTypes(NativeWebRequest webRequest) throws HttpMediaTypeNotAcceptableException {
            String[] headerValueArray = webRequest.getHeaderValues("Accept");
            if (headerValueArray == null) {
                headerValueArray = webRequest.getHeaderValues("Accept".toLowerCase());
                if (headerValueArray == null) {
                    return DEFAULT_MEDIA_TYPE;
                }
                if (headerValueArray.length == 1 && "*/*".equals(headerValueArray[0])) {
                    return DEFAULT_MEDIA_TYPE;
                }
            }
            List<String> headerValues = Arrays.asList(headerValueArray);
            try {
                List<MediaType> mediaTypes = MediaType.parseMediaTypes(headerValues);
                DepreHelper.sortMediaTypes(mediaTypes);
                return !CollectionUtils.isEmpty((Collection)mediaTypes) ? mediaTypes : DEFAULT_MEDIA_TYPE;
            }
            catch (InvalidMediaTypeException ex) {
                throw new HttpMediaTypeNotAcceptableException("Could not parse 'Accept' header " + headerValues + ": " + ex.getMessage());
            }
        }
    }
}

