/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.bean;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import net.ideahut.springboot.task.TaskHandler;
import net.ideahut.springboot.util.FrameworkUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public interface BeanConfigure<T> {
    public Callable<T> configureBean(ApplicationContext var1);

    public boolean isBeanConfigured();

    public static <T> void checkBeanConfigure(BeanConfigure<T> bean) {
        Assert.notNull(bean, (String)"bean is required");
        if (!bean.isBeanConfigured()) {
            throw FrameworkUtil.exception(bean.getClass().getName() + " not configured; call runBeanConfigure() before using it");
        }
    }

    public static void runBeanConfigure(TaskHandler taskHandler, final ApplicationContext applicationContext, Class<?> ... types) throws Exception {
        Map map;
        HashSet<BeanConfigure> beans = new HashSet<BeanConfigure>();
        if (types != null) {
            for (Class<?> type : types) {
                BeanConfigure bean = (BeanConfigure)applicationContext.getBean(type);
                bean.configureBean(applicationContext).call();
                beans.add(bean);
            }
        }
        if (taskHandler != null && (map = applicationContext.getBeansOfType(BeanConfigure.class)) != null) {
            for (final Map.Entry entry : map.entrySet()) {
                if (beans.contains(entry.getValue())) continue;
                taskHandler.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ((BeanConfigure)entry.getValue()).configureBean(applicationContext).call();
                        }
                        catch (Exception e) {
                            throw FrameworkUtil.exception(e);
                        }
                    }
                });
            }
        }
    }
}

