/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.audit;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.ideahut.springboot.annotation.Audit;
import net.ideahut.springboot.audit.AuditAccessible;
import net.ideahut.springboot.audit.AuditHandler;
import net.ideahut.springboot.audit.AuditHelper;
import net.ideahut.springboot.audit.AuditInfo;
import net.ideahut.springboot.audit.AuditRequest;
import net.ideahut.springboot.audit.DatabaseAuditProperties;
import net.ideahut.springboot.audit.DepreHelper;
import net.ideahut.springboot.audit.MultiTableHelper;
import net.ideahut.springboot.audit.SingleTableHelper;
import net.ideahut.springboot.bean.BeanConfigure;
import net.ideahut.springboot.entity.EntityBase;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.init.InitMapper;
import net.ideahut.springboot.object.Page;
import net.ideahut.springboot.task.TaskHandler;
import net.ideahut.springboot.util.FrameworkUtil;
import org.hibernate.SessionFactory;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public class DatabaseMultiAuditHandler
implements AuditHandler,
InitializingBean,
InitMapper,
BeanConfigure<AuditHandler> {
    private static final Logger log = LoggerFactory.getLogger(DatabaseMultiAuditHandler.class);
    private final Map<String, AuditHelper.TrxManagerAccessible> trxManagerAccessibles = new LinkedHashMap<String, AuditHelper.TrxManagerAccessible>();
    private boolean reconfigured = false;
    private AuditHelper.AEnable tenable;
    private AuditHelper.ATable ttable;
    private AuditHelper.AGenerate tgenerate;
    private AuditHelper.ALength tlength;
    private AuditHelper.AColumn tcolumn;
    private EntityTrxManager entityTrxManager;
    private TaskHandler taskHandler;
    private DatabaseAuditProperties properties;
    private Boolean rejectNonAuditEntity;

    public DatabaseMultiAuditHandler setEntityTrxManager(EntityTrxManager entityTrxManager) {
        this.entityTrxManager = entityTrxManager;
        return this;
    }

    public DatabaseMultiAuditHandler setTaskHandler(TaskHandler taskHandler) {
        this.taskHandler = taskHandler;
        return this;
    }

    public DatabaseMultiAuditHandler setProperties(DatabaseAuditProperties properties) {
        this.properties = properties;
        return this;
    }

    public DatabaseMultiAuditHandler setRejectNonAuditEntity(Boolean rejectNonAuditEntity) {
        this.rejectNonAuditEntity = rejectNonAuditEntity;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.entityTrxManager, (String)"entityTrxManager is required");
        Assert.notNull((Object)this.taskHandler, (String)"taskHandler is required");
        if (this.properties == null) {
            this.properties = new DatabaseAuditProperties();
        }
        this.tenable = new AuditHelper.AEnable(this.properties);
        this.ttable = new AuditHelper.ATable(this.properties);
        this.tgenerate = new AuditHelper.AGenerate(this.properties);
        this.tlength = new AuditHelper.ALength(this.properties);
        this.tcolumn = new AuditHelper.AColumn(this.properties);
    }

    @Override
    public void onInitMapper() throws Exception {
        AuditHelper.Mapper.initialize(this.trxManagerAccessibles);
    }

    @Override
    public Callable<AuditHandler> configureBean(ApplicationContext applicationContext) {
        final DatabaseMultiAuditHandler self = this;
        return new Callable<AuditHandler>(){

            @Override
            public AuditHandler call() throws Exception {
                if (DatabaseMultiAuditHandler.this.tenable == null) {
                    self.afterPropertiesSet();
                }
                if (DatabaseMultiAuditHandler.this.tenable != null && DatabaseMultiAuditHandler.this.tenable.isAudit()) {
                    DatabaseMultiAuditHandler.this.reconfigure();
                }
                DatabaseMultiAuditHandler.this.reconfigured = true;
                return self;
            }
        };
    }

    private void reconfigure() throws Exception {
        for (TrxManagerInfo trxManagerInfo : this.entityTrxManager.getTrxManagerInfos()) {
            EntityIntegrator auditIntegrator;
            EntityIntegrator trxIntegrator = trxManagerInfo.getIntegrator();
            String auditIdentifier = EntityIntegrator.getAuditIdentifier((SessionFactory)trxIntegrator.getSessionFactory());
            if (auditIdentifier.isEmpty()) continue;
            AuditHelper.TrxManagerAccessible trxManagerAccessible = this.trxManagerAccessibles.getOrDefault(auditIdentifier, null);
            Assert.isNull((Object)trxManagerAccessible, (String)("Duplicate trxManagerAccessible for audit id: " + auditIdentifier));
            SessionFactory auditSessionFactory = EntityIntegrator.getAuditSessionFactory((SessionFactory)trxIntegrator.getSessionFactory());
            if (auditSessionFactory != null) {
                if (auditSessionFactory.getProperties().get("hibernate.hbm2ddl.auto") != null) {
                    auditSessionFactory.getProperties().put("hibernate.hbm2ddl.auto", "none");
                }
                auditIntegrator = EntityIntegrator.of(auditSessionFactory.getProperties(), trxIntegrator.getAnnotatedClasses());
            } else {
                auditIntegrator = EntityIntegrator.of(trxIntegrator.getSettings(), trxIntegrator.getAnnotatedClasses());
            }
            trxManagerAccessible = new AuditHelper.TrxManagerAccessible();
            trxManagerAccessible.setAuditIntegrator(auditIntegrator);
            trxManagerAccessible.setAuditIdentifier(auditIdentifier);
            trxManagerAccessible.setTrxManagerInfo(trxManagerInfo);
            trxManagerAccessible.setTableAccessibles(new LinkedHashMap());
            Database database = trxIntegrator.getMetadata().getDatabase();
            Namespace namespace = database.getDefaultNamespace();
            for (Table table : namespace.getTables()) {
                EntityInfo entityInfo = trxManagerInfo.getEntityInfo(table.getSchema(), table.getName());
                Audit annotAudit = entityInfo != null ? entityInfo.getAnnotation(Audit.class) : null;
                if (annotAudit == null || !annotAudit.value()) continue;
                Table newTable = AuditHelper.copyTable(auditIntegrator, table, this.ttable, this.tenable);
                for (Column column : table.getColumns()) {
                    Column newColumn = column.clone();
                    if (newColumn.getPrecision() != null && newColumn.getPrecision() > this.tgenerate.getMaxPrecision()) {
                        newColumn.setPrecision(Integer.valueOf(this.tgenerate.getMaxPrecision()));
                    }
                    if (newColumn.getScale() != null && newColumn.getScale() > this.tgenerate.getMaxScale()) {
                        newColumn.setScale(Integer.valueOf(this.tgenerate.getMaxScale()));
                    }
                    newColumn.setUnique(false);
                    newColumn.setNullable(true);
                    newTable.addColumn(newColumn);
                }
                if (this.tenable.isIndex()) {
                    for (Index index : table.getIndexes().values()) {
                        Index newIndex = new Index();
                        newIndex.setName(this.ttable.getPrefix() + index.getName() + this.ttable.getSuffix());
                        newIndex.setTable(newTable);
                        List<Column> columns = DepreHelper.getIndexColumns(index);
                        for (Column column : columns) {
                            Column newColumn = column.clone();
                            newColumn.setUnique(false);
                            newIndex.addColumn((Selectable)newColumn);
                        }
                        newTable.addIndex(newIndex);
                    }
                    MultiTableHelper.createIdIndex(entityInfo, newTable);
                }
                AuditHelper.TableAccessible tableAccessible = MultiTableHelper.createTableAccessible(auditIntegrator, entityInfo, newTable, this.tcolumn, this.tlength);
                tableAccessible.setAuditIntegrator(auditIntegrator);
                trxManagerAccessible.getTableAccessibles().put(entityInfo.getEntityClass(), tableAccessible);
            }
            AuditHelper.TableAccessible tableAccessible = SingleTableHelper.createTableAccessible(auditIntegrator, auditIdentifier, this.ttable, this.tlength);
            tableAccessible.setAuditIntegrator(auditIntegrator);
            trxManagerAccessible.getTableAccessibles().put(Void.class, tableAccessible);
            this.trxManagerAccessibles.put(auditIdentifier, trxManagerAccessible);
        }
        if (this.tgenerate.isTable()) {
            for (Map.Entry entry : this.trxManagerAccessibles.entrySet()) {
                for (Map.Entry<Class<?>, AuditHelper.TableAccessible> table : ((AuditHelper.TrxManagerAccessible)entry.getValue()).getTableAccessibles().entrySet()) {
                    EntityHelper.createTable(((AuditHelper.TrxManagerAccessible)entry.getValue()).getAuditIntegrator(), table.getValue().getTable(), false);
                }
            }
        }
    }

    @Override
    public boolean isBeanConfigured() {
        return this.reconfigured;
    }

    public void save(String action, Object object) {
        BeanConfigure.checkBeanConfigure(this);
        if (this.tenable.isAudit()) {
            String auditId;
            if (object == null) {
                return;
            }
            AuditInfo auditInfo = AuditInfo.context();
            if (Boolean.TRUE.equals(auditInfo.getSkip())) {
                log.debug("Skip audit {}", (Object)auditInfo);
                return;
            }
            String string = auditId = auditInfo.getId() != null ? auditInfo.getId() : "";
            if (auditId.isEmpty() && (auditId = EntityIntegrator.getAuditIdentifier()).isEmpty()) {
                return;
            }
            String fAuditId = auditId;
            this.taskHandler.execute(() -> {
                EntityInfo entityInfo;
                AuditHelper.TrxManagerAccessible trxManagerAccessible = this.trxManagerAccessibles.get(fAuditId);
                if (trxManagerAccessible == null) {
                    log.warn("TrxManagerAccessible is not found, for audit id: {}", (Object)fAuditId);
                    return;
                }
                AuditHelper.TableAccessible tableAccessible = trxManagerAccessible.getTableAccessibles().get(object.getClass());
                if (tableAccessible == null) {
                    if (object instanceof EntityBase && Boolean.TRUE.equals(this.rejectNonAuditEntity)) {
                        return;
                    }
                    tableAccessible = trxManagerAccessible.getTableAccessibles().get(Void.class);
                }
                if ((entityInfo = tableAccessible.getEntityInfo()) != null) {
                    try {
                        MultiTableHelper.save(tableAccessible, auditInfo, action, object);
                    }
                    catch (Exception e) {
                        throw FrameworkUtil.exception(e);
                    }
                } else {
                    SingleTableHelper.save(tableAccessible, auditInfo, action, object);
                }
            });
        }
    }

    public AuditRequest getRequest(byte[] data) {
        return AuditHelper.getAuditRequest(data);
    }

    public Page getList(AuditRequest auditRequest) {
        EntityInfo entityInfo;
        BeanConfigure.checkBeanConfigure(this);
        Assert.notNull((Object)auditRequest, (String)"Audit request required");
        String manager = auditRequest.getManager();
        TrxManagerInfo trxManagerInfo = this.entityTrxManager.getTrxManagerInfo(manager);
        if (trxManagerInfo == null) {
            trxManagerInfo = this.entityTrxManager.getDefaultTrxManagerInfo();
        }
        SessionFactoryImplementor sessionFactory = trxManagerInfo.getIntegrator().getSessionFactory();
        String auditId = EntityIntegrator.getAuditIdentifier((SessionFactory)sessionFactory);
        Assert.hasLength((String)auditId, (String)"Audit ID is not found");
        AuditHelper.TrxManagerAccessible trxManagerAccessible = this.trxManagerAccessibles.get(auditId);
        Assert.notNull((Object)trxManagerAccessible, (String)("TrxManagerAccessible is not found, for auditId: " + auditId));
        AuditHelper.TableAccessible tableAccessible = trxManagerAccessible.getTableAccessibles().get(auditRequest.getClassOfEntity());
        if (tableAccessible == null) {
            tableAccessible = trxManagerAccessible.getTableAccessibles().get(Void.class);
        }
        if ((entityInfo = tableAccessible.getEntityInfo()) != null) {
            return MultiTableHelper.list(tableAccessible, auditRequest);
        }
        return SingleTableHelper.list(tableAccessible, auditRequest);
    }

    public byte[] getBytes(String manager, String id) {
        SessionFactoryImplementor sessionFactory;
        String auditId;
        BeanConfigure.checkBeanConfigure(this);
        TrxManagerInfo trxManagerInfo = this.entityTrxManager.getTrxManagerInfo(manager);
        if (trxManagerInfo == null) {
            trxManagerInfo = this.entityTrxManager.getDefaultTrxManagerInfo();
        }
        if ((auditId = EntityIntegrator.getAuditIdentifier((SessionFactory)(sessionFactory = trxManagerInfo.getIntegrator().getSessionFactory()))).isEmpty()) {
            return null;
        }
        AuditHelper.TrxManagerAccessible trxManagerAccessible = this.trxManagerAccessibles.get(auditId);
        Assert.notNull((Object)trxManagerAccessible, (String)("trxManagerAccessible is not found, for auditId: " + auditId));
        AuditHelper.TableAccessible tableAccessible = trxManagerAccessible.getTableAccessibles().get(Void.class);
        return SingleTableHelper.bytes(tableAccessible, id);
    }

    public Map<String, AuditAccessible> getAccessibles() {
        return AuditHelper.getAccessibles(this.trxManagerAccessibles);
    }
}

